`timescale 1ns / 1ps

module decoder
 #(
    parameter INS_WIDTH    =    32,
    parameter JUMP_OP      =    7'b1101111,
	 parameter JR_OP        =    7'b1100111,
    parameter BRANCH_OP    =    7'b1100011,
    parameter LOAD_OP      =    7'b0000011,
    parameter STORE_OP     =    7'b0100011,
    parameter I_TYPE_OP    =    7'b0010011,
    parameter R_TYPE_OP    =    7'b0110011,
	 parameter LUI_OP       =    7'b0110111,
	 parameter AUIPC_OP     =    7'b0010111, 
    parameter BEQ_FUNCT    =    3'b000,
    parameter BNE_FUNCT    =    3'b001,
    parameter BLT_FUNCT    =    3'b100,
    parameter BGE_FUNCT    =    3'b101,
    parameter BLTU_FUNCT   =    3'b110,
    parameter BGEU_FUNCT   =    3'b111,
    parameter LW_FUNCT     =    3'b010,
    parameter LH_FUNCT     =    3'b001,
    parameter LB_FUNCT     =    3'b000,
	 parameter LBU_FUNCT    =    3'b100,
	 parameter LHU_FUNCT    =    3'b101,
	 parameter SB_FUNCT     =    3'b000,
	 parameter SH_FUNCT     =    3'b001,
    parameter SW_FUNCT     =    3'b010,
    parameter ADDI_FUNCT   =    3'b000,
    parameter SLTI_FUNCT   =    3'b010,
    parameter SLTIU_FUNCT  =    3'b011,
    parameter XORI_FUNCT   =    3'b100,
    parameter ORI_FUNCT    =    3'b110,
    parameter ANDI_FUNCT   =    3'b111,
    parameter SLLI_FUNCT   =    3'b001,
    parameter SRLI_FUNCT   =    3'b101,
    parameter SRAI_FUNCT   =    3'b101,
    parameter ADD_FUNCT    =    3'b000,
    parameter SUB_FUNCT    =    3'b000,
    parameter SLL_FUNCT    =    3'b001,
    parameter SLT_FUNCT    =    3'b010,
    parameter SLTU_FUNCT   =    3'b011,
    parameter XOR_FUNCT    =    3'b100,
    parameter SRL_FUNCT    =    3'b101,
    parameter SRA_FUNCT    =    3'b101,
    parameter OR_FUNCT     =    3'b110,
    parameter AND_FUNCT    =    3'b111,
    parameter SUB_SRA_FUNCT =   7'b0100000
  )
  (
    input      [31 : 0]    ins,
    input      [31 : 0]    rs1_data,
    input      [31 : 0]    rs2_data,
    output                 J,
    output                 JR,
	 output                 LUI,
	 output                 AUIPC,
    output reg             Branch,
    output                 ram_read,
    output                 ram_write,
    output                 regs_write,                 
    output reg [1 : 0]     op_b_sel,
    output reg [2 : 0]     load_type,
	 output reg [1 : 0]     store_type,
    output reg [5 : 0]     alu_op,
	 output                 flush
  );
  
  
  assign flush=J||JR||Branch;
  //ȡopfunct3funct7
  wire [6 : 0] op,
               funct7;
  wire [2 : 0] funct3;
  assign op = ins[6 : 0];
  assign funct3 = ins[14 : 12];
  assign funct7 = ins[31 : 25];
  //Jump
  assign J = op == JUMP_OP;
  assign JR = op == JR_OP;
  //LUI
  assign LUI = op == LUI_OP;
  //AUIPC
  assign AUIPC = op ==AUIPC_OP;
  //BranchǷתж
  always@(*)
  begin
    if (op == BRANCH_OP) begin
      case(funct3)
        BEQ_FUNCT: begin
                    if (rs1_data == rs2_data)
                      Branch = 1;
                    else
                      Branch = 0;
                   end
        BNE_FUNCT: begin
                    if (rs1_data != rs2_data)
                      Branch = 1;
                    else
                      Branch = 0;
                   end  
        BLT_FUNCT: begin
                    if ($signed(rs1_data) < $signed(rs2_data))
                      Branch = 1;
                    else
                      Branch = 0;
                   end
        BGE_FUNCT: begin
                    if ($signed(rs1_data) >= $signed(rs2_data))
                      Branch = 1;
                    else
                      Branch = 0;
                   end
        BLTU_FUNCT: begin
                      if (rs1_data < rs2_data)
                        Branch = 1;
                      else
                        Branch = 0;
                    end 
        BGEU_FUNCT: begin
                      if (rs1_data >= rs2_data)
                        Branch = 1;
                      else
                        Branch = 0;
                    end
		  default   : Branch = 0;
      endcase
    end
	 else Branch = 0;
  end
  //Load & Store
  always@(*)
  begin
    if (op == LOAD_OP)begin
      op_b_sel = 2'b01;
      case(funct3)
        LW_FUNCT:  load_type = 3'b000;
        LH_FUNCT:  load_type = 3'b001;
        LB_FUNCT:  load_type = 3'b010;
        LBU_FUNCT: load_type = 3'b011;
		  LHU_FUNCT: load_type = 3'b100;
		  default  : load_type = 3'b101;
      endcase
    end
    else if (op == STORE_OP)begin
      op_b_sel = 2'b10;
		case(funct3)
			SB_FUNCT:  store_type = 2'b00;
			SH_FUNCT:  store_type = 2'b01;
			SW_FUNCT:  store_type = 2'b10;
			default :  store_type = 2'b11;
		endcase
	 end
	 else if(op == I_TYPE_OP)
		op_b_sel = 2'b01;
	 else if(op == R_TYPE_OP)
		op_b_sel = 2'b00;
	 else 
		op_b_sel=2'b11;
  end
  //ָΪRISL
  wire   r_type_ins, i_type_ins, load_ins, store_ins;
  assign load_ins   = op == LOAD_OP;
  assign store_ins  = op == STORE_OP;
  assign i_type_ins = op == I_TYPE_OP;
  assign r_type_ins = op == R_TYPE_OP;
  //źŵĶ
  assign ram_read   = load_ins;
  assign ram_write  = store_ins;
  assign regs_write = r_type_ins || i_type_ins || load_ins || J || JR || LUI || AUIPC;
  
  //岻ָͬALU_Code,ALU
  localparam alu_ram   =  6'b000000;
  localparam alu_add   =  6'b000001;
  localparam alu_sub   =  6'b001010;
  localparam alu_slt   =  6'b000010;
  localparam alu_sltu  =  6'b000011;
  localparam alu_sll   =  6'b000100;
  localparam alu_srl   =  6'b000101;
  localparam alu_sra   =  6'b000110;
  localparam alu_xor   =  6'b000111;
  localparam alu_or    =  6'b001000;
  localparam alu_and   =  6'b001001;
  localparam alu_nop   =  6'b111111;
  
  always@(*)
  begin
    case(op)
      LOAD_OP:    alu_op = alu_ram;
      STORE_OP:   alu_op = alu_ram;
      I_TYPE_OP:  begin
                    case(funct3)
                      ADDI_FUNCT:   alu_op = alu_add;
                      SLTI_FUNCT:   alu_op = alu_slt;
                      SLTIU_FUNCT:  alu_op = alu_sltu;
                      SLLI_FUNCT:   alu_op = alu_sll;
                      SRLI_FUNCT:   if(funct7 == SUB_SRA_FUNCT)
                                      alu_op = alu_sra;
                                    else
                                      alu_op = alu_srl;
                      XORI_FUNCT:   alu_op = alu_xor;
                      ORI_FUNCT:    alu_op = alu_or;
                      ANDI_FUNCT:   alu_op = alu_and;
                      default:      alu_op = alu_nop;
                    endcase
                  end           
      R_TYPE_OP:  begin
                    case(funct3)
                      ADD_FUNCT:    if(funct7 == SUB_SRA_FUNCT)
                                      alu_op = alu_sub;
                                    else
                                      alu_op = alu_add;
                      SLT_FUNCT:    alu_op = alu_slt;
                      SLTU_FUNCT:   alu_op = alu_sltu;
                      SLL_FUNCT:    alu_op = alu_sll;
                      SRL_FUNCT:    if(funct7 == SUB_SRA_FUNCT)
                                      alu_op = alu_sra;
                                    else
                                      alu_op = alu_srl;
                      XOR_FUNCT:    alu_op = alu_xor;
                      OR_FUNCT:     alu_op = alu_or;
                      AND_FUNCT:    alu_op = alu_and;
                      default:      alu_op = alu_nop;
                    endcase
                  end
      default:    alu_op = alu_nop;
    endcase
  end

endmodule
