# 
# Synthesis run script generated by Vivado
# 

proc create_report { reportName command } {
  set status "."
  append status $reportName ".fail"
  if { [file exists $status] } {
    eval file delete [glob $status]
  }
  send_msg_id runtcl-4 info "Executing : $command"
  set retval [eval catch { $command } msg]
  if { $retval != 0 } {
    set fp [open $status w]
    close $fp
    send_msg_id runtcl-5 warning "$msg"
  }
}
create_project -in_memory -part xc7vx485tffg1157-1

set_param project.singleFileAddWarning.threshold 0
set_param project.compositeFile.enableAutoGeneration 0
set_param synth.vivado.isSynthRun true
set_property webtalk.parent_dir E:/verilogtest/RISCV_CPU/RISCV_CPU/RISCV_CPU.cache/wt [current_project]
set_property parent.project_path E:/verilogtest/RISCV_CPU/RISCV_CPU/RISCV_CPU.xpr [current_project]
set_property default_lib xil_defaultlib [current_project]
set_property target_language Verilog [current_project]
set_property ip_output_repo e:/verilogtest/RISCV_CPU/RISCV_CPU/RISCV_CPU.cache/ip [current_project]
set_property ip_cache_permissions {read write} [current_project]
read_verilog -library xil_defaultlib {
  E:/verilogtest/RISCV_CPU/ROM.v
  E:/verilogtest/RISCV_CPU/Registers.v
  E:/verilogtest/RISCV_CPU/RAM.v
  E:/verilogtest/RISCV_CPU/myreg.v
  E:/verilogtest/RISCV_CPU/mux4.v
  E:/verilogtest/RISCV_CPU/forward.v
  E:/verilogtest/RISCV_CPU/dependence_detect.v
  E:/verilogtest/RISCV_CPU/decoder.v
  E:/verilogtest/RISCV_CPU/ALU.v
  E:/verilogtest/RISCV_CPU/CPU.v
}
# Mark all dcp files as not used in implementation to prevent them from being
# stitched into the results of this synthesis run. Any black boxes in the
# design are intentionally left as such for best results. Dcp files will be
# stitched into the design at a later time, either when this synthesis run is
# opened, or when it is stitched into a dependent implementation run.
foreach dcp [get_files -quiet -all -filter file_type=="Design\ Checkpoint"] {
  set_property used_in_implementation false $dcp
}
set_param ips.enableIPCacheLiteLoad 0
close [open __synthesis_is_running__ w]

synth_design -top CPU -part xc7vx485tffg1157-1


# disable binary constraint mode for synth run checkpoints
set_param constraints.enableBinaryConstraints false
write_checkpoint -force -noxdef CPU.dcp
create_report "synth_1_synth_report_utilization_0" "report_utilization -file CPU_utilization_synth.rpt -pb CPU_utilization_synth.pb"
file delete __synthesis_is_running__
close [open __synthesis_is_complete__ w]
