`timescale 1ns / 1ps
module RAM #(
    parameter DATAWIDTH = 32,
    parameter ADDRWIDTH = 6
)
(
    input clk,
    input wr_en,
    input [ADDRWIDTH-1 : 0] addr,
    input [DATAWIDTH-1 : 0] wr_data,
    input rd_en,
    input [(DATAWIDTH/8)-1 : 0] wstrb,
    output reg [DATAWIDTH-1 :0] rd_data
);

	initial begin
		mem[0]=0;
		mem[1]=1;
		mem[2]=2;
		mem[3]=3;
		mem[4]=4;
		mem[5]=5;
		mem[6]=6;
		mem[7]=7;
		mem[8]=8;
		mem[9]=9;
		mem[10]=10;
		mem[11]=11;
		mem[12]=12;
		mem[13]=13;
		mem[14]=14;
		mem[15]=15;
		mem[16]=16;
		mem[17]=17;
		mem[18]=18;
		mem[19]=19;
		mem[20]=20;
		mem[21]=21;
		mem[22]=22;
		mem[23]=23;
		mem[24]=24;
		mem[25]=25;
		mem[26]=26;
		mem[27]=27;
		mem[28]=28;
		mem[29]=29;
	end

    reg [DATAWIDTH-1 : 0] mem [0 : (1<<ADDRWIDTH)-1];
    // write data to memory
    wire [DATAWIDTH-1 : 0] strb_data;
    genvar i; 
    generate for(i = 0; i < (DATAWIDTH/8); i = i + 1) begin :RAM_GEN
        assign strb_data[8*i+:8] = (wstrb[i]) ? wr_data[8*i+:8] : mem[addr][8*i+:8];
    end
    endgenerate

    always@(posedge clk)begin
        if(wr_en)
            mem[addr] <= strb_data;
    end
    // read data from memory
    
    always @(rd_en , addr) begin
        if(rd_en) rd_data = mem[addr];
        else rd_data = 0;
    end
endmodule 