`timescale 1 ns / 1 ps
module NVDLA#(
	parameter  RAM_BASE_ADDR	= 32'h00000000,//RAMҪƫƵַ,RAM[i]ַΪ i<<2+RAM_BASE_ADDR
	parameter  CSB_BASE_ADDR   = 32'h00001000,//CSBҪƫƵַ,CSB[i]ַΪ i<<2+CSB_BASE_ADDR,ADDR[12]=1'b1;
	// Thread ID Width
	parameter integer C_M_AXI_ID_WIDTH	= 1,//,ͬһͬһŵ밴˳ִ,ִ֮˳ûҪ
	// Width of Address Bus
	parameter integer C_M_AXI_ADDR_WIDTH	= 32,
	// Width of Data Bus
	parameter integer C_M_AXI_DATA_WIDTH	= 32,
	// Width of User Write Address Bus
	parameter integer C_M_AXI_AWUSER_WIDTH	= 1,//û
	// Width of User Read Address Bus
	parameter integer C_M_AXI_ARUSER_WIDTH	= 1,//û
	// Width of User Write Data Bus
	parameter integer C_M_AXI_WUSER_WIDTH	= 1,//û
	// Width of User Read Data Bus
	parameter integer C_M_AXI_RUSER_WIDTH	= 1,//û
	// Width of User Response Bus
	parameter integer C_M_AXI_BUSER_WIDTH	= 1//û
)
(
	input  clk,
	input  rst_n,
	
	//CSBͨź
	input  wire CSB2NVDLA_VALID,
	output wire CSB2NVDLA_READY,
	input  wire [15:0] CSB2NVDLA_ADDR,
	input  wire [31:0] CSB2NVDLA_WDAT,
	input  wire CSB2NVDLA_WRITE,
	input  wire CSB2NVDLA_NPOSTED,
	output wire NVDLA2CSB_VALID,
	output wire [31:0] NVDLA2CSB_DATA,
	output wire NVDLA2CSB_WR_COMPLETE,
	
	output wire NVDLA2CORE_INTERRUPT,//񼴾,ݸCPU
	
	//DBBIFͨѶź
	// Global Clock Signal.
	input wire  NVDLA_M_AXI_ACLK,
	// Master Interface Write Address ID
	output wire [C_M_AXI_ID_WIDTH-1 : 0] NVDLA_M_AXI_AWID,
	// Master Interface Write Address
	output wire [C_M_AXI_ADDR_WIDTH-1 : 0] NVDLA_M_AXI_AWADDR,
	// Burst length. The burst length gives the exact number of transfers in a burst
	output wire [7 : 0] NVDLA_M_AXI_AWLEN,
	// Burst size. This signal indicates the size of each transfer in the burst
	output wire [2 : 0] NVDLA_M_AXI_AWSIZE,
	// Burst type. The burst type and the size information, 
 // determine how the address for each transfer within the burst is calculated.
	output wire [1 : 0] NVDLA_M_AXI_AWBURST,
	// Lock type. Provides additional information about the
 // atomic characteristics of the transfer.
	output wire  NVDLA_M_AXI_AWLOCK,
	// Memory type. This signal indicates how transactions
 // are required to progress through a system.
	output wire [3 : 0] NVDLA_M_AXI_AWCACHE,
	// Protection type. This signal indicates the privilege
 // and security level of the transaction, and whether
 // the transaction is a data access or an instruction access.
	output wire [2 : 0] NVDLA_M_AXI_AWPROT,
	// Quality of Service, QoS identifier sent for each write transaction.
	output wire [3 : 0] NVDLA_M_AXI_AWQOS,
	// Optional User-defined signal in the write address channel.
	output wire [C_M_AXI_AWUSER_WIDTH-1 : 0] NVDLA_M_AXI_AWUSER,
	// Write address valid. This signal indicates that
 // the channel is signaling valid write address and control information.
	output wire  NVDLA_M_AXI_AWVALID,
	// Write address ready. This signal indicates that
 // the slave is ready to accept an address and associated control signals
	input wire  NVDLA_M_AXI_AWREADY,
	// Master Interface Write Data.
	output wire [C_M_AXI_DATA_WIDTH-1 : 0] NVDLA_M_AXI_WDATA,
	// Write strobes. This signal indicates which byte
 // lanes hold valid data. There is one write strobe
 // bit for each eight bits of the write data bus.
	output wire [C_M_AXI_DATA_WIDTH/8-1 : 0] NVDLA_M_AXI_WSTRB,
	// Write last. This signal indicates the last transfer in a write burst.
	output wire  NVDLA_M_AXI_WLAST,
	// Optional User-defined signal in the write data channel.
	output wire [C_M_AXI_WUSER_WIDTH-1 : 0] NVDLA_M_AXI_WUSER,
	// Write valid. This signal indicates that valid write
 // data and strobes are available
	output wire  NVDLA_M_AXI_WVALID,
	// Write ready. This signal indicates that the slave
 // can accept the write data.
	input wire  NVDLA_M_AXI_WREADY,
	// Master Interface Write Response.
	input wire [C_M_AXI_ID_WIDTH-1 : 0] NVDLA_M_AXI_BID,
	// Write response. This signal indicates the status of the write transaction.
	input wire [1 : 0] NVDLA_M_AXI_BRESP,
	// Optional User-defined signal in the write response channel
	input wire [C_M_AXI_BUSER_WIDTH-1 : 0] NVDLA_M_AXI_BUSER,
	// Write response valid. This signal indicates that the
 // channel is signaling a valid write response.
	input wire  NVDLA_M_AXI_BVALID,
	// Response ready. This signal indicates that the master
 // can accept a write response.
	output wire  NVDLA_M_AXI_BREADY,
	// Master Interface Read Address.
	output wire [C_M_AXI_ID_WIDTH-1 : 0] NVDLA_M_AXI_ARID,
	// Read address. This signal indicates the initial
 // address of a read burst transaction.
	output wire [C_M_AXI_ADDR_WIDTH-1 : 0] NVDLA_M_AXI_ARADDR,
	// Burst length. The burst length gives the exact number of transfers in a burst
	output wire [7 : 0] NVDLA_M_AXI_ARLEN,
	// Burst size. This signal indicates the size of each transfer in the burst
	output wire [2 : 0] NVDLA_M_AXI_ARSIZE,
	// Burst type. The burst type and the size information, 
 // determine how the address for each transfer within the burst is calculated.
	output wire [1 : 0] NVDLA_M_AXI_ARBURST,
	// Lock type. Provides additional information about the
 // atomic characteristics of the transfer.
	output wire  NVDLA_M_AXI_ARLOCK,
	// Memory type. This signal indicates how transactions
 // are required to progress through a system.
	output wire [3 : 0] NVDLA_M_AXI_ARCACHE,
	// Protection type. This signal indicates the privilege
 // and security level of the transaction, and whether
 // the transaction is a data access or an instruction access.
	output wire [2 : 0] NVDLA_M_AXI_ARPROT,
	// Quality of Service, QoS identifier sent for each read transaction
	output wire [3 : 0] NVDLA_M_AXI_ARQOS,
	// Optional User-defined signal in the read address channel.
	output wire [C_M_AXI_ARUSER_WIDTH-1 : 0] NVDLA_M_AXI_ARUSER,
	// Write address valid. This signal indicates that
 // the channel is signaling valid read address and control information
	output wire  NVDLA_M_AXI_ARVALID,
	// Read address ready. This signal indicates that
 // the slave is ready to accept an address and associated control signals
	input wire  NVDLA_M_AXI_ARREADY,
	// Read ID tag. This signal is the identification tag
 // for the read data group of signals generated by the slave.
	input wire [C_M_AXI_ID_WIDTH-1 : 0] NVDLA_M_AXI_RID,
	// Master Read Data
	input wire [C_M_AXI_DATA_WIDTH-1 : 0] NVDLA_M_AXI_RDATA,
	// Read response. This signal indicates the status of the read transfer
	input wire [1 : 0] NVDLA_M_AXI_RRESP,
	// Read last. This signal indicates the last transfer in a read burst
	input wire  NVDLA_M_AXI_RLAST,
	// Optional User-defined signal in the read address channel.
	input wire [C_M_AXI_RUSER_WIDTH-1 : 0] NVDLA_M_AXI_RUSER,
	// Read valid. This signal indicates that the channel
 // is signaling the required read data.
	input wire  NVDLA_M_AXI_RVALID,
	// Read ready. This signal indicates that the master can
 // accept the read data and response information.
	output wire  NVDLA_M_AXI_RREADY
);
	
	//ִһA*B״̬,ӷͶ󵽽(õ)ٵ˵Ľ,ٵд,ٵдľ˵Ľ,ٵ
	parameter SEND_AR=4'b0000;
	parameter RECV_DATA=4'b0001;
	parameter CALCUTE=4'b0010;
	parameter SEND_AW=4'b0011;
	parameter WRITE_DATA=4'b0100;
	parameter FINISH=4'b0101;
	
	reg csb2nvdla_ready;
	reg nvdla2csb_valid;
	reg [31:0] nvdla2csb_data;
	reg nvdla2csb_wr_complete;
	reg nvdla2core_interrupt;
	wire [6:0] csb_address;
	integer i,j;
	reg recv_AB_flag;
	reg[31:0] csb[26:0];//csb[7:0]rg0,csb[15:8]rg1,csb[0]:conv_enable0,csb[1]:ͣ0˷csb[2]:ADRAMеʼַ(BA)csb[3]:洢DRAMеʼַcsb[8]conv_enable1,csb[9]:cͣ0˷csb[10]:ADRAMеʼַBA棩csb[11]:DRAMеʼַcsb[16]:producer_pointer,csb[17]:consumer_pointer
	reg[31:0] DBBIF[26:0];//DBBIF[8:0]ھA,DBBIF[17:9]ھB,DBBIF[26:18]ڼC=A*BõC
	//C=A*B
	reg [31:0] A[2:0][2:0];//˾A
	reg [31:0] B[2:0][2:0];//˾B
	reg [3:0] state;//״ָ̬ʾ,SEND_AR,RECV_DATA,CALCUTE,SEND_AW,WRITE_DATA,FINISH״̬
	reg [5:0] aw_len;//дݳ
	reg [5:0] ar_len;//ȡݳ
	reg [C_M_AXI_ADDR_WIDTH-1 : 0] axi_awaddr;
	reg  axi_awvalid;
	reg [C_M_AXI_DATA_WIDTH-1 : 0] axi_wdata;
	reg  axi_wlast;
	reg  axi_wvalid;
	reg  axi_bready;
	reg [C_M_AXI_ADDR_WIDTH-1 : 0] axi_araddr;
	reg  axi_arvalid;
	reg  axi_rready;
	//write beat count in a burst
	reg [4 : 0] write_index;
	//read beat count in a burst
	reg [4 : 0] read_index;
	
	reg  	start_single_burst_write;//ߺд
	reg  	start_single_burst_read;//ߺȡ
	reg  	writes_done;//־д
	reg  	reads_done;//־ȡ
	reg  	burst_write_active;//߱־ڽд
	reg  	burst_read_active;//߱־ڽжȡ
	reg write_task;//һAXIͨȻstart_single_burst_writeд
	reg read_task;//һAXIͨȻstart_single_burst_readȡ
	wire  wnext;//дɼдһ
	wire  rnext;//öȡȡɼöȡһ
	reg  	init_txn_pulse;//AXIͨ
	wire [4:0] dbbif_waddress; //õҪWDATAӦDBBIFĵַ
	
	assign CSB2NVDLA_READY = csb2nvdla_ready;
	assign NVDLA2CSB_VALID = nvdla2csb_valid;
	assign NVDLA2CSB_DATA = nvdla2csb_data;
	assign NVDLA2CSB_WR_COMPLETE = nvdla2csb_wr_complete;
	
	assign NVDLA2CORE_INTERRUPT = nvdla2core_interrupt;

	//I/O Connections. Write Address (AW)
	assign NVDLA_M_AXI_AWID	= 'b0;//û
	assign NVDLA_M_AXI_AWADDR	= (csb[17]) ? {csb[11],2'b00}:{csb[3],2'b00};//csb[17]ָʾĿǰѡĸĴ,csb[11]csb[3]ָʾRAMĵַ
	//Burst LENgth is number of transaction beats, minus 1
	assign NVDLA_M_AXI_AWLEN	= aw_len - 1;
	//Size should be C_M_AXI_DATA_WIDTH, in 2^SIZE bytes, otherwise narrow bursts are used
	assign NVDLA_M_AXI_AWSIZE	= 4;
	//INCR burst type is usually used, except for keyhole bursts
	assign NVDLA_M_AXI_AWBURST	= 2'b01;
	assign NVDLA_M_AXI_AWLOCK	= 1'b0;
	//Update value to 4'b0011 if coherent accesses to be used via the Zynq ACP port. Not Allocated, Modifiable, not Bufferable. Not Bufferable since this example is meant to test memory, not intermediate cache. 
	assign NVDLA_M_AXI_AWCACHE	= 4'b0010;
	assign NVDLA_M_AXI_AWPROT	= 3'h0;
	assign NVDLA_M_AXI_AWQOS	= 4'h0;
	assign NVDLA_M_AXI_AWUSER	= 'b1;
	assign NVDLA_M_AXI_AWVALID	= axi_awvalid;
	//Write Data(W)
	assign NVDLA_M_AXI_WDATA	= axi_wdata;
	//All bursts are complete and aligned in this example
	assign NVDLA_M_AXI_WSTRB	= {(C_M_AXI_DATA_WIDTH/8){1'b1}};
	assign NVDLA_M_AXI_WLAST	= axi_wlast;
	assign NVDLA_M_AXI_WUSER	= 'b0;
	assign NVDLA_M_AXI_WVALID	= axi_wvalid;
	//Write Response (B)
	assign NVDLA_M_AXI_BREADY	= axi_bready;
	//Read Address (AR)
	assign NVDLA_M_AXI_ARID	= 'b0;
	assign NVDLA_M_AXI_ARADDR	=csb[17] ? {csb[10],2'b00}:{csb[2],2'b00};
	//Burst LENgth is number of transaction beats, minus 1
	assign NVDLA_M_AXI_ARLEN	= ar_len - 1;
	//Size should be C_M_AXI_DATA_WIDTH, in 2^n bytes, otherwise narrow bursts are used
	assign NVDLA_M_AXI_ARSIZE	= 4;
	//INCR burst type is usually used, except for keyhole bursts
	assign NVDLA_M_AXI_ARBURST	= 2'b01;
	assign NVDLA_M_AXI_ARLOCK	= 1'b0;
	//Update value to 4'b0011 if coherent accesses to be used via the Zynq ACP port. Not Allocated, Modifiable, not Bufferable. Not Bufferable since this example is meant to test memory, not intermediate cache. 
	assign NVDLA_M_AXI_ARCACHE	= 4'b0010;
	assign NVDLA_M_AXI_ARPROT	= 3'h0;
	assign NVDLA_M_AXI_ARQOS	= 4'h0;
	assign NVDLA_M_AXI_ARUSER	= 'b1;
	assign NVDLA_M_AXI_ARVALID	= axi_arvalid;
	//Read and Read Response (R)
	assign NVDLA_M_AXI_RREADY	= axi_rready;

	//ʼд֮ǰAXiؼĴ
	always @(posedge NVDLA_M_AXI_ACLK) begin
		if(rst_n == 0) init_txn_pulse<=1'b0;
		else if(~init_txn_pulse && (write_task || read_task)) init_txn_pulse<=1'b1;
		else init_txn_pulse<=1'b0;
	end

	//涨ȡд
	always @(posedge NVDLA_M_AXI_ACLK) begin
		if(rst_n == 0) begin
			aw_len <= 9;
			ar_len <= 18;
		end
	end
	
	//--------------------
	//Write Address Channel
	//--------------------

	// The purpose of the write address channel is to request the address and 
	// command information for the entire transaction.  It is a single beat
	// of information.

	// The AXI4 Write address channel in this example will continue to initiate
	// write commands as fast as it is allowed by the slave/interconnect.. 

	always @(posedge NVDLA_M_AXI_ACLK) begin                                                            
		if (rst_n == 0 || init_txn_pulse == 1'b1 ) axi_awvalid <= 1'b0;               
		else if (~axi_awvalid && start_single_burst_write) axi_awvalid <= 1'b1;                                                                                                         
		/* Once asserted, VALIDs cannot be deasserted, so axi_awvalid      
		must wait until transaction is accepted */                         
		else if (NVDLA_M_AXI_AWREADY && axi_awvalid) axi_awvalid <= 1'b0;                                                             
		else axi_awvalid <= axi_awvalid;                                      
	end                                                                

	//Forward movement occurs when the write channel is valid and ready
	assign wnext = NVDLA_M_AXI_WREADY & axi_wvalid;                                   
	                                                                                    
	// WVALID logic, similar to the axi_awvalid always block above                      
	always @(posedge NVDLA_M_AXI_ACLK) begin                                                                             
		if (rst_n == 0 || init_txn_pulse == 1'b1 ) axi_wvalid <= 1'b0;                                                                                                                                  
		// If previously not valid, start next transaction                              
		else if (~axi_wvalid && start_single_burst_write) axi_wvalid <= 1'b1;                                                                                                                               
		/* If WREADY and too many writes, throttle WVALID                               
		Once asserted, VALIDs cannot be deasserted, so WVALID                           
		must wait until burst is complete with WLAST */                                 
		else if (wnext && axi_wlast) axi_wvalid <= 1'b0;                                                           
		else axi_wvalid <= axi_wvalid;                                                     
	end                                                                               
	                                                                                    
	                                                                                    
	//WLAST־дΪһ                     
	always @(posedge NVDLA_M_AXI_ACLK) begin                                                                             
		if (rst_n == 0 || init_txn_pulse == 1'b1 ) axi_wlast <= 1'b0;                                                                                                                                   
		else if (((write_index == aw_len-2 && aw_len >= 2) && wnext) || (aw_len == 1 )) axi_wlast <= 1'b1;                                                                                                                                   
		// Deassrt axi_wlast when the last write data has been                          
		// accepted by the slave with a valid response                                  
		else if (wnext) axi_wlast <= 1'b0;                                                            
		else if (axi_wlast && aw_len == 1) axi_wlast <= 1'b0;                                                            
		else axi_wlast <= axi_wlast;                                                       
	end                                                                               
	                                                                                    
	                                                                                    
	/* Burst length counter. Uses extra counter register bit to indicate terminal       
	 count to reduce decode logic */                                                    
	always @(posedge NVDLA_M_AXI_ACLK) begin                                                                             
		if (rst_n == 0 || init_txn_pulse == 1'b1 || aw_len == 1'b1) write_index <= 0;                                                                                                                                     
		else if (wnext && (write_index != aw_len-1)) write_index <= write_index + 1;                                                                                                                        
		else write_index <= write_index;                                                   
	end
	
	 //dbbif_waddressΪӦдRAMеDBBIFݵĵַ                                                                   
	 assign dbbif_waddress = 18 + write_index;   

	 always @(*) begin
		 axi_wdata = DBBIF[dbbif_waddress];
	 end

	//----------------------------
	//Write Response (B) Channel
	//----------------------------

	//The write response channel provides feedback that the write has committed
	//to memory. BREADY will occur when all of the data and the write address
	//has arrived and been accepted by the slave.

	//The write issuance (number of outstanding write addresses) is started by 
	//the Address Write transfer, and is completed by a BREADY/BRESP.

	//While negating BREADY will eventually throttle the AWREADY signal, 
	//it is best not to throttle the whole data channel this way.

	//The BRESP bit [1] is used indicate any errors from the interconnect or
	//slave for the entire write burst. This example will capture the error 
	//into the ERROR output. 

	  always @(posedge NVDLA_M_AXI_ACLK)                                     
	  begin                                                                 
	    if (rst_n == 0 || init_txn_pulse == 1'b1 )                                            
	      begin                                                             
	        axi_bready <= 1'b0;                                             
	      end                                                               
	    // accept/acknowledge bresp with axi_bready by the master           
	    // when NVDLA_M_AXI_BVALID is asserted by slave                           
	    else if (NVDLA_M_AXI_BVALID && ~axi_bready && write_index == aw_len - 1)                               
	      begin                                                             
	        axi_bready <= 1'b1;                                             
	      end                                                               
	    // deassert after one clock cycle                                   
	    else if (axi_bready)                                                
	      begin                                                             
	        axi_bready <= 1'b0;                                             
	      end                                                               
	    // retain the previous value                                        
	    else                                                                
	      axi_bready <= axi_bready;                                         
	  end                                                                   
	                                                                
	//----------------------------
	//Read Address Channel
	//----------------------------

	//The Read Address Channel (AW) provides a similar function to the
	//Write Address channel- to provide the tranfer qualifiers for the burst.

	//In this example, the read address increments in the same
	//manner as the write address channel.
	
	  always @(posedge NVDLA_M_AXI_ACLK) begin                                                                                                                   
	    if (rst_n == 0 || init_txn_pulse == 1'b1 ) axi_arvalid <= 1'b0;                                                                                                              
	    else if (~axi_arvalid && start_single_burst_read) axi_arvalid <= 1'b1;                                                                                                    
	    else if (NVDLA_M_AXI_ARREADY && axi_arvalid) axi_arvalid <= 1'b0;                                                                                                    
	    else axi_arvalid <= axi_arvalid;                                    
	  end
	  
	//--------------------------------
	//Read Data (and Response) Channel
	//--------------------------------

	 // Forward movement occurs when the channel is valid and ready   
	  assign rnext = NVDLA_M_AXI_RVALID && axi_rready;                                                                        
	// Burst length counter. Uses extra counter register bit to indicate    
	// terminal count to reduce decode logic                                
	  always @(posedge NVDLA_M_AXI_ACLK)                                          
	  begin                                                                 
	    if (rst_n == 0 || init_txn_pulse == 1'b1 || start_single_burst_read)                  
	      begin                                                             
	        read_index <= 0;                                                
	      end                                                               
	    else if (rnext && (read_index != ar_len-1))              
	      begin                                                             
	        read_index <= read_index + 1;                                   
	      end                                                               
	    else                                                                
	      read_index <= read_index;                                         
	  end
	always @(posedge NVDLA_M_AXI_ACLK) begin
		if(rnext) DBBIF[read_index] <=NVDLA_M_AXI_RDATA;
	end
	                                                                        
	/*                                                                      
	 The Read Data channel returns the results of the read request          
	                                                                        
	 In this example the data checker is always able to accept              
	 more data, so no need to throttle the RREADY signal                    
	 */                                                                     
	  always @(posedge NVDLA_M_AXI_ACLK) begin                                                                 
	    if (rst_n == 0 || init_txn_pulse == 1'b1 ) axi_rready <= 1'b0;                                                                                                          
	    // accept/acknowledge rdata/rresp with axi_rready by the master     
	    // when NVDLA_M_AXI_RVALID is asserted by slave                           
	    else if (NVDLA_M_AXI_RVALID) begin
			if (NVDLA_M_AXI_RLAST && axi_rready) axi_rready <= 1'b0;                                    
	      else axi_rready <= 1'b1;                                  
	    end                                                        
	  end                                            	                                                                                                                                                                                                    	                                                                                                            	                                                                                                                                                                    
	                                                                                                            
	  always @ ( posedge NVDLA_M_AXI_ACLK) begin                                                                                                    
		if (rst_n == 1'b0 ) begin                                                                                               
	        // reset condition                                                                                  
	        // All the signals are assigned default values under reset condition                                
	        start_single_burst_write <= 1'b0;                                                                   
	        start_single_burst_read  <= 1'b0;                                                                     
	      end                                                                                                   
	    else begin                                                                                                                                                                                                                                                 
			if ( init_txn_pulse == 1'b1 && write_task == 1'b1) begin                                                                                                                                                                                                                                                                                           
				if (~axi_awvalid && ~start_single_burst_write && ~burst_write_active) start_single_burst_write <= 1'b1;                                                       
			end
			else start_single_burst_write <= 1'b0; //Negate to generate a pulse                                                                                                                                                                                                                                                                                                           
			if(init_txn_pulse == 1'b1 && read_task == 1'b1) begin                                                                
				if (~axi_arvalid && ~burst_read_active && ~start_single_burst_read) start_single_burst_read <= 1'b1;                                                                                                                                                                  
			end
			else start_single_burst_read <= 1'b0; //Negate to generate a pulse                                                                                                                                                                                        
	  	end //MASTER_EXECUTION_PROC                                                                               
	  end                                                                                                           
	                                                                                                            
	  // burst_write_active signal is asserted when there is a burst write transaction                          
	  // is initiated by the assertion of start_single_burst_write. burst_write_active                          
	  // signal remains asserted until the burst write is accepted by the slave                                 
	  always @(posedge NVDLA_M_AXI_ACLK)                                                                              
	  begin                                                                                                     
	    if (rst_n == 0 || init_txn_pulse == 1'b1)                                                                                 
	      burst_write_active <= 1'b0;                                                                                                                                                                                   
	    //The burst_write_active is asserted when a write burst transaction is initiated                        
	    else if (start_single_burst_write)                                                                      
	      burst_write_active <= 1'b1;                                                                           
	    else if (NVDLA_M_AXI_BVALID && axi_bready)                                                                    
	      burst_write_active <= 0;                                                                              
	  end                                                                                                       
	                                                                                                            
	 // Check for last write completion.                                                                        
	                                                                                                            
	 // This logic is to qualify the last write count with the final write                                      
	 // response. This demonstrates how to confirm that a write has been                                        
	 // committed.                                                                                              

	  always @(posedge NVDLA_M_AXI_ACLK)                                                                	                                                                                                                          
	  begin                                                                                                     
	    if (rst_n == 0 || init_txn_pulse == 1'b1)                                                                                 
	      writes_done <= 1'b0;                                                                                  
	                                                                                                            
	    //The writes_done should be associated with a bready response                                           
	    //else if (NVDLA_M_AXI_BVALID && axi_bready && (write_burst_counter == {(C_NO_BURSTS_REQ-1){1}}) && axi_wlast)
	    else if (NVDLA_M_AXI_BVALID && axi_bready )                          
	      writes_done <= 1'b1;                                                                                  
	    else                                                                                                    
	      writes_done <= 1'b0;                                                                           
	    end                                                                                                     
	                                                                                                            
	  // burst_read_active signal is asserted when there is a burst write transaction                           
	  // is initiated by the assertion of start_single_burst_write. start_single_burst_read                     
	  // signal remains asserted until the burst read is accepted by the master                                 
	  always @(posedge NVDLA_M_AXI_ACLK)                                                                              
	  begin                                                                                                     
	    if (rst_n == 0 || init_txn_pulse == 1'b1)                                                                                 
	      burst_read_active <= 1'b0;                                                                            
	                                                                                                            
	    //The burst_write_active is asserted when a write burst transaction is initiated                        
	    else if (start_single_burst_read)                                                                       
	      burst_read_active <= 1'b1;                                                                            
	    else if (NVDLA_M_AXI_RVALID && axi_rready && NVDLA_M_AXI_RLAST)                                                     
	      burst_read_active <= 0;                                                                               
	    end                                                                                                     
	                                                                                                            
	                                                                                                            
	 // Check for last read completion.                                                                         
	                                                                                                            
	 // This logic is to qualify the last read count with the final read                                        
	 // response. This demonstrates how to confirm that a read has been                                         
	 // committed.                                                                                              
	                                                                                                            
	  always @(posedge NVDLA_M_AXI_ACLK)                                                                              
	  begin                                                                                                     
	    if (rst_n == 0 || init_txn_pulse == 1'b1)                                                                                 
	      reads_done <= 1'b0;                                                                                   
	                                                                                                            
	    //The reads_done should be associated with a rready response                                            
	    //else if (NVDLA_M_AXI_BVALID && axi_bready && (write_burst_counter == {(C_NO_BURSTS_REQ-1){1}}) && axi_wlast)
	    else if (NVDLA_M_AXI_RVALID && axi_rready && (read_index == ar_len-1))
	      reads_done <= 1'b1;                                                                                   
	    else                                                                                                    
	      reads_done <= 1'b0;                                                                             
	    end                                                                                                     

	// Add user logic here

	// User logic ends
		
	always @(posedge clk) begin
		if(!rst_n) csb2nvdla_ready<=1'b0;
		else begin
			if(CSB2NVDLA_VALID&&(!csb2nvdla_ready)) csb2nvdla_ready<=1'b1;
			else csb2nvdla_ready<=1'b0;
		end
	end
	
	assign csb_address = CSB2NVDLA_ADDR[8:2];//õдcsbĵַ,һcsbĴ4ֽ,Դ[8:2][6:0]
	
	always @(posedge clk) begin
		if(!rst_n) begin
			csb[0]<=0;
			csb[1]<=0;
			csb[2]<=0;
			csb[3]<=0;
			csb[4]<=0;
			csb[5]<=0;
			csb[6]<=0;
			csb[7]<=0;
			csb[8]<=0;
			csb[9]<=0;
			csb[10]<=0;
			csb[11]<=0;
			csb[12]<=0;
			csb[13]<=0;
			csb[14]<=0;
			csb[15]<=0;
			csb[16]<=0;
			csb[17]<=0;
			csb[18]<=0;
			csb[19]<=0;
			csb[20]<=0;
			csb[21]<=0;
			csb[22]<=0;
			csb[23]<=0;
			csb[24]<=0;
			csb[25]<=0;
			csb[26]<=0;
		end
		else begin
			if(CSB2NVDLA_VALID && (!csb2nvdla_ready) && CSB2NVDLA_WRITE) begin
				if(CSB2NVDLA_ADDR[12]==1'b1) csb[csb_address] <=CSB2NVDLA_WDAT;//CSB2NVDLA_ADDR[12]==1'b1CSBĵַ
			end
			else ;
			if(state == FINISH) begin
				if(csb[17]) csb[8]<=0;
				else csb[0]<=0;
			end
		end
	end
	
	//nvdla2csb_wr_completeź 
	always @(posedge clk) begin
		if(!rst_n) nvdla2csb_wr_complete <=1'b0;
		else begin
			if(CSB2NVDLA_VALID && (!csb2nvdla_ready) && CSB2NVDLA_NPOSTED &&CSB2NVDLA_WRITE && CSB2NVDLA_ADDR[12]==1'b1) nvdla2csb_wr_complete <=1'b1;
			else nvdla2csb_wr_complete <=1'b0;
		end
	end
	
	//csb2nvdla_validڵõҪȡ֪ͨʱ
	always @(posedge clk) begin
		if(!rst_n) nvdla2csb_valid<=1'b0;
		else begin
			if(CSB2NVDLA_VALID && csb2nvdla_ready && (!CSB2NVDLA_WRITE)) begin
				if(CSB2NVDLA_ADDR[12]==1'b1) begin
					nvdla2csb_valid<=1'b1;
					nvdla2csb_data<=csb[csb_address];
				end
			end
			else nvdla2csb_valid<=1'b0;
		end
	end
	
	always @(posedge clk) begin
	  if(!rst_n) begin
		 state<=4'b0000;
		 nvdla2core_interrupt<=1'b0;
		 recv_AB_flag<=1'b0;
		 DBBIF[0]<=0;
		 DBBIF[1]<=0;
		 DBBIF[2]<=0;
		 DBBIF[3]<=0;
		 DBBIF[4]<=0;
		 DBBIF[5]<=0;
		 DBBIF[6]<=0;
		 DBBIF[7]<=0;
		 DBBIF[8]<=0;
		 DBBIF[9]<=0;
		 DBBIF[10]<=0;
		 DBBIF[11]<=0;
		 DBBIF[12]<=0;
		 DBBIF[13]<=0;
		 DBBIF[14]<=0;
		 DBBIF[15]<=0;
		 DBBIF[16]<=0;
		 DBBIF[17]<=0;
		 DBBIF[18]<=0;
		 DBBIF[19]<=0;
		 DBBIF[20]<=0;
		 DBBIF[21]<=0;
		 DBBIF[22]<=0;
		 DBBIF[23]<=0;
		 DBBIF[24]<=0;
		 DBBIF[25]<=0;
		 DBBIF[26]<=0;
		 write_task<=1'b0;
		 read_task<=1'b0;
	  end
	  else begin
		 if((csb[17]==1'b0&&csb[0])||(csb[17]==1'b1&&csb[8])) begin
			if(state==SEND_AR) begin
           read_task<=1'b1;
			  state<=RECV_DATA;
			end
			else if(state==RECV_DATA) begin
             if(init_txn_pulse && read_task) read_task<=1'b0;
				 if(reads_done) begin//ȡ
					state<=CALCUTE;
				 end
			end
			else if(state==CALCUTE) begin
			  if(!recv_AB_flag) begin
				 B[2][2]<=DBBIF[17];
				 B[2][1]<=DBBIF[16];
				 B[2][0]<=DBBIF[15];
				 B[1][2]<=DBBIF[14];
				 B[1][1]<=DBBIF[13];
				 B[1][0]<=DBBIF[12];
				 B[0][2]<=DBBIF[11];
				 B[0][1]<=DBBIF[10];
				 B[0][0]<=DBBIF[9];
				 A[2][2]<=DBBIF[8];
				 A[2][1]<=DBBIF[7];
				 A[2][0]<=DBBIF[6];
				 A[1][2]<=DBBIF[5];
				 A[1][1]<=DBBIF[4];
				 A[1][0]<=DBBIF[3];
				 A[0][2]<=DBBIF[2];
				 A[0][1]<=DBBIF[1];
				 A[0][0]<=DBBIF[0];
				 recv_AB_flag<=1'b1;
			  end
			  else begin
				 for(i=0; i<3;i=i+1) begin
					for(j=0;j<3;j=j+1) begin
					  DBBIF[18+i*3+j]<=A[i][0]*B[0][j]+A[i][1]*B[1][j]+A[i][2]*B[2][j];
					end
				 end
				 recv_AB_flag<=1'b0;
				 state<=SEND_AW;
			  end
			end
			else if(state==SEND_AW) begin
                write_task<=1'b1;
                state<=WRITE_DATA;
			end
			else if(state==WRITE_DATA) begin
                if(init_txn_pulse && write_task) write_task<=1'b0;
                else ;
                if(writes_done) state<=FINISH;
				else ;
			end
			else if(state==FINISH) begin
			  nvdla2core_interrupt<=1'b1;
			  state<=0;
			  if(csb[17]) csb[17]<=0;
			  else csb[17] <=1;
			end
			else begin
			  nvdla2core_interrupt<=1'b0;
			  state<=0;
			end
		 end
	  end
	end
	
endmodule 
