
`timescale 1 ns / 1 ps

	module CPU_CONTROL #
	(
		parameter  C_M_TARGET_SLAVE_BASE_ADDR	= 32'h40000000,
		// Burst Length. Supports 1, 2, 4, 8, 16, 32, 64, 128, 256 burst lengths
		parameter integer C_M_AXI_BURST_LEN	= 9,
		// Thread ID Width
		parameter integer C_M_AXI_ID_WIDTH	= 1,
		// Width of Address Bus
		parameter integer C_M_AXI_ADDR_WIDTH	= 32,
		// Width of Data Bus
		parameter integer C_M_AXI_DATA_WIDTH	= 32,
		// Width of User Write Address Bus
		parameter integer C_M_AXI_AWUSER_WIDTH	= 0,
		// Width of User Read Address Bus
		parameter integer C_M_AXI_ARUSER_WIDTH	= 0,
		// Width of User Write Data Bus
		parameter integer C_M_AXI_WUSER_WIDTH	= 0,
		// Width of User Read Data Bus
		parameter integer C_M_AXI_RUSER_WIDTH	= 0,
		// Width of User Response Bus
		parameter integer C_M_AXI_BUSER_WIDTH	= 0
	)
	(
	// Users to add ports here
	
	// Global Clock Signal.
	input wire  CPU_M_AXI_ACLK,
	// Global Reset Singal. This Signal is Active Low
	input wire  rst_n,
	// Master Interface Write Address ID
	output wire [C_M_AXI_ID_WIDTH-1 : 0] CPU_AWID,
	// Master Interface Write Address
	output wire [C_M_AXI_ADDR_WIDTH-1 : 0] CPU_AWADDR,
	// Burst length. The burst length gives the exact number of transfers in a burst
	output wire [7 : 0] CPU_AWLEN,
	// Burst size. This signal indicates the size of each transfer in the burst
	output wire [2 : 0] CPU_AWSIZE,
	// Burst type. The burst type and the size information, 
	// determine how the address for each transfer within the burst is calculated.
	output wire [1 : 0] CPU_AWBURST,
	// Lock type. Provides additional information about the
	// atomic characteristics of the transfer.
	output wire  CPU_AWLOCK,
	// Memory type. This signal indicates how transactions
	// are required to progress through a system.
	output wire [3 : 0] CPU_AWCACHE,
	// Protection type. This signal indicates the privilege
	// and security level of the transaction, and whether
	// the transaction is a data access or an instruction access.
	output wire [2 : 0] CPU_AWPROT,
	// Quality of Service, QoS identifier sent for each write transaction.
	output wire [3 : 0] CPU_AWQOS,
	// Optional User-defined signal in the write address channel.
	output wire [C_M_AXI_AWUSER_WIDTH-1 : 0] CPU_AWUSER,
	// Write address valid. This signal indicates that
	// the channel is signaling valid write address and control information.
	output wire  CPU_AWVALID,
	// Write address ready. This signal indicates that
	// the slave is ready to accept an address and associated control signals
	input wire  CPU_AWREADY,
	// Master Interface Write Data.
	output wire [C_M_AXI_DATA_WIDTH-1 : 0] CPU_WDATA,
	// Write strobes. This signal indicates which byte
	// lanes hold valid data. There is one write strobe
	// bit for each eight bits of the write data bus.
	output wire [C_M_AXI_DATA_WIDTH/8-1 : 0] CPU_WSTRB,
	// Write last. This signal indicates the last transfer in a write burst.
	output wire  CPU_WLAST,
	// Optional User-defined signal in the write data channel.
	output wire [C_M_AXI_WUSER_WIDTH-1 : 0] CPU_WUSER,
	// Write valid. This signal indicates that valid write
	// data and strobes are available
	output wire  CPU_WVALID,
	// Write ready. This signal indicates that the slave
	// can accept the write data.
	input wire  CPU_WREADY,
	// Master Interface Write Response.
	input wire [C_M_AXI_ID_WIDTH-1 : 0] CPU_BID,
	// Write response. This signal indicates the status of the write transaction.
	input wire [1 : 0] CPU_BRESP,
	// Optional User-defined signal in the write response channel
	input wire [C_M_AXI_BUSER_WIDTH-1 : 0] CPU_BUSER,
	// Write response valid. This signal indicates that the
	// channel is signaling a valid write response.
	input wire  CPU_BVALID,
	// Response ready. This signal indicates that the master
	// can accept a write response.
	output wire  CPU_BREADY,
	// Master Interface Read Address.
	output wire [C_M_AXI_ID_WIDTH-1 : 0] CPU_ARID,
	// Read address. This signal indicates the initial
	// address of a read burst transaction.
	output wire [C_M_AXI_ADDR_WIDTH-1 : 0] CPU_ARADDR,
	// Burst length. The burst length gives the exact number of transfers in a burst
	output wire [7 : 0] CPU_ARLEN,
	// Burst size. This signal indicates the size of each transfer in the burst
	output wire [2 : 0] CPU_ARSIZE,
	// Burst type. The burst type and the size information, 
	// determine how the address for each transfer within the burst is calculated.
	output wire [1 : 0] CPU_ARBURST,
	// Lock type. Provides additional information about the
	// atomic characteristics of the transfer.
	output wire  CPU_ARLOCK,
	// Memory type. This signal indicates how transactions
	// are required to progress through a system.
	output wire [3 : 0] CPU_ARCACHE,
	// Protection type. This signal indicates the privilege
	// and security level of the transaction, and whether
	// the transaction is a data access or an instruction access.
	output wire [2 : 0] CPU_ARPROT,
	// Quality of Service, QoS identifier sent for each read transaction
	output wire [3 : 0] CPU_ARQOS,
	// Optional User-defined signal in the read address channel.
	output wire [C_M_AXI_ARUSER_WIDTH-1 : 0] CPU_ARUSER,
	// Write address valid. This signal indicates that
	// the channel is signaling valid read address and control information
	output wire  CPU_ARVALID,
	// Read address ready. This signal indicates that
	// the slave is ready to accept an address and associated control signals
	input wire  CPU_ARREADY,
	// Read ID tag. This signal is the identification tag
	// for the read data group of signals generated by the slave.
	input wire [C_M_AXI_ID_WIDTH-1 : 0] CPU_RID,
	// Master Read Data
	input wire [C_M_AXI_DATA_WIDTH-1 : 0] CPU_RDATA,
	// Read response. This signal indicates the status of the read transfer
	input wire [1 : 0] CPU_RRESP,
	// Read last. This signal indicates the last transfer in a read burst
	input wire  CPU_RLAST,
	// Optional User-defined signal in the read address channel.
	input wire [C_M_AXI_RUSER_WIDTH-1 : 0] CPU_RUSER,
	// Read valid. This signal indicates that the channel
	// is signaling the required read data.
	input wire  CPU_RVALID,
	// Read ready. This signal indicates that the master can
	// accept the read data and response information.
	output wire  CPU_RREADY
	);
                                                    
	// Burst length for transactions, in C_M_AXI_DATA_WIDTHs.
	// Non-2^n lengths will eventually cause bursts across 4K address boundaries.
	 localparam integer C_MASTER_LENGTH	= 12;
	wire WRITE_EN;
	wire [31:0] WRITE_ADDRESS;
	wire [31:0] WRITE_DATA;
	wire READ_EN;
	wire [31:0] READ_ADDRESS;
	wire [31:0] READ_DATA;
	wire CPU_WRITE_DONE;
	wire CPU_READ_DONE;
	//AXI4 internal temp signals
	reg [5:0] aw_len;
	reg [5:0] ar_len;
	reg [C_M_AXI_ADDR_WIDTH-1 : 0] 	axi_awaddr;
	reg  	axi_awvalid;
	reg [C_M_AXI_DATA_WIDTH-1 : 0] 	axi_wdata;
	reg  	axi_wlast;
	reg  	axi_wvalid;
	reg  	axi_bready;
	reg [C_M_AXI_ADDR_WIDTH-1 : 0] 	axi_araddr;
	reg  	axi_arvalid;
	reg  	axi_rready;
	//write beat count in a burst
	reg [4 : 0] 	write_index;
	//read beat count in a burst
	reg [4 : 0] 	read_index;
	//The burst counters are used to track the number of burst transfers of C_M_AXI_BURST_LEN burst length needed to transfer 2^C_MASTER_LENGTH bytes of data.
	reg  	start_single_burst_write;
	reg  	start_single_burst_read;
	reg  	writes_done;
	reg  	reads_done;
	reg  	burst_write_active;
	reg  	burst_read_active;
	reg write_task;
	reg read_task;
	//Interface response error flags
	wire  	wnext;
	wire  	rnext;
	reg  	init_txn_pulse;
	// I/O Connections assignments

	//I/O Connections. Write Address (AW)
	assign CPU_AWID	= 'b0;
	//The AXI address is a concatenation of the target base address + active offset range
	assign CPU_AWADDR	= axi_awaddr;
	//Burst LENgth is number of transaction beats, minus 1
	assign CPU_AWLEN	= aw_len - 1;
	//Size should be C_M_AXI_DATA_WIDTH, in 2^SIZE bytes, otherwise narrow bursts are used
	assign CPU_AWSIZE	= 4;
	//INCR burst type is usually used, except for keyhole bursts
	assign CPU_AWBURST	= 2'b01;
	assign CPU_AWLOCK	= 1'b0;
	//Update value to 4'b0011 if coherent accesses to be used via the Zynq ACP port. Not Allocated, Modifiable, not Bufferable. Not Bufferable since this example is meant to test memory, not intermediate cache. 
	assign CPU_AWCACHE	= 4'b0010;
	assign CPU_AWPROT	= 3'h0;
	assign CPU_AWQOS	= 4'h0;
	assign CPU_AWUSER	= 'b1;
	assign CPU_AWVALID	= axi_awvalid;
	//Write Data(W)
	assign CPU_WDATA	= axi_wdata;
	//All bursts are complete and aligned in this example
	assign CPU_WSTRB	= {(C_M_AXI_DATA_WIDTH/8){1'b1}};
	assign CPU_WLAST	= axi_wlast;
	assign CPU_WUSER	= 'b0;
	assign CPU_WVALID	= axi_wvalid;
	//Write Response (B)
	assign CPU_BREADY	= axi_bready;
	//Read Address (AR)
	assign CPU_ARID	= 'b0;
	assign CPU_ARADDR	= axi_araddr;
	//Burst LENgth is number of transaction beats, minus 1
	assign CPU_ARLEN	= ar_len - 1;
	//Size should be C_M_AXI_DATA_WIDTH, in 2^n bytes, otherwise narrow bursts are used
	assign CPU_ARSIZE	= 4;
	//INCR burst type is usually used, except for keyhole bursts
	assign CPU_ARBURST	= 2'b01;
	assign CPU_ARLOCK	= 1'b0;
	//Update value to 4'b0011 if coherent accesses to be used via the Zynq ACP port. Not Allocated, Modifiable, not Bufferable. Not Bufferable since this example is meant to test memory, not intermediate cache. 
	assign CPU_ARCACHE	= 4'b0010;
	assign CPU_ARPROT	= 3'h0;
	assign CPU_ARQOS	= 4'h0;
	assign CPU_ARUSER	= 'b1;
	assign CPU_ARVALID	= axi_arvalid;
	//Read and Read Response (R)
	assign CPU_RREADY	= axi_rready;
	//Example design I/O
	assign READ_DATA = CPU_RDATA;//õCPUҪ
	assign CPU_READ_DONE = CPU_RVALID;//ɣCPU_READ_DONEΪڼREAD_DATAΪҪ
	assign CPU_WRITE_DONE = writes_done;//д

	//涨ȡд
	always @(posedge CPU_M_AXI_ACLK) begin
		if(rst_n == 0) begin
			aw_len <= 1;
			ar_len <= 1;
		end
	end

    //ÿζдǰĳʼ
    always @(posedge CPU_M_AXI_ACLK) begin
        if(rst_n == 0) init_txn_pulse <=1'b0;
        else begin
            if(!init_txn_pulse && (write_task == 1'b1 || read_task == 1'b1)) init_txn_pulse<=1'b1;
            else init_txn_pulse<=1'b0;
        end
    end
	//--------------------
	//Write Address Channel
	//--------------------

	// The purpose of the write address channel is to request the address and 
	// command information for the entire transaction.  It is a single beat
	// of information.

	// The AXI4 Write address channel in this example will continue to initiate
	// write commands as fast as it is allowed by the slave/interconnect.
	// The address will be incremented on each accepted address transaction,
	// by burst_size_byte to point to the next address. 

	  always @(posedge CPU_M_AXI_ACLK)                                   
	  begin                                                                                                                                    
	    if (rst_n == 0 || init_txn_pulse == 1'b1 )                                           
	      begin                                                            
	        axi_awvalid <= 1'b0;                                           
	      end                                                              
	    // If previously not valid , start next transaction                
	    else if (~axi_awvalid && start_single_burst_write)                 
	      begin                                                            
	        axi_awvalid <= 1'b1;                                           
	      end                                                              
	    /* Once asserted, VALIDs cannot be deasserted, so axi_awvalid      
	    must wait until transaction is accepted */                         
	    else if (CPU_AWREADY && axi_awvalid)                             
	      begin                                                            
	        axi_awvalid <= 1'b0;                                           
	      end                                                              
	    else                                                               
	      axi_awvalid <= axi_awvalid;                                      
	    end                                                                
	
	//--------------------
	//Write Data Channel
	//--------------------

	//The write data will continually try to push write data across the interface.

	//The amount of data accepted will depend on the AXI slave and the AXI
	//Interconnect settings, such as if there are FIFOs enabled in interconnect.

	//Note that there is no explicit timing relationship to the write address channel.
	//The write channel has its own throttling flag, separate from the AW channel.

	//Synchronization between the channels must be determined by the user.

	//The simpliest but lowest performance would be to only issue one address write
	//and write data burst at a time.

	//In this example they are kept in sync by using the same address increment
	//and burst sizes. Then the AW and W channels have their transactions measured
	//with threshold counters as part of the user logic, to make sure neither 
	//channel gets too far ahead of each other.

	//Forward movement occurs when the write channel is valid and ready

	  assign wnext = CPU_WREADY & axi_wvalid;                                   
	                                                                                    
	// WVALID logic, similar to the axi_awvalid always block above                      
	  always @(posedge CPU_M_AXI_ACLK)                                                      
	  begin                                                                             
	    if (rst_n == 0 || init_txn_pulse == 1'b1 )                                                        
	      begin                                                                         
	        axi_wvalid <= 1'b0;                                                         
	      end                                                                           
	    // If previously not valid, start next transaction                              
	    else if (~axi_wvalid && start_single_burst_write)                               
	      begin                                                                         
	        axi_wvalid <= 1'b1;                                                         
	      end                                                                           
	    /* If WREADY and too many writes, throttle WVALID                               
	    Once asserted, VALIDs cannot be deasserted, so WVALID                           
	    must wait until burst is complete with WLAST */                                 
	    else if (wnext && axi_wlast)                                                    
	      axi_wvalid <= 1'b0;                                                           
	    else                                                                            
	      axi_wvalid <= axi_wvalid;                                                     
	  end                                                                               
	                                                                                    
	                                                                                    
	//WLAST generation on the MSB of a counter underflow                                
	// WVALID logic, similar to the axi_awvalid always block above                      
	  always @(posedge CPU_M_AXI_ACLK)                                                      
	  begin                                                                             
	    if (rst_n == 0 || init_txn_pulse == 1'b1 )                                                        
	      begin                                                                         
	        axi_wlast <= 1'b0;                                                          
	      end                                                                           
	    // axi_wlast is asserted when the write index                                   
	    // count reaches the penultimate count to synchronize                           
	    // with the last write data when write_index is b1111                           
	    // else if (&(write_index[C_TRANSACTIONS_NUM-1:1])&& ~write_index[0] && wnext)  
	    else if (((write_index == aw_len-2 && aw_len >= 2) && wnext) || (aw_len == 1 ))
	      begin                                                                         
	        axi_wlast <= 1'b1;                                                          
	      end                                                                           
	    // Deassrt axi_wlast when the last write data has been                          
	    // accepted by the slave with a valid response                                  
	    else if (wnext)                                                                 
	      axi_wlast <= 1'b0;                                                            
	    else if (axi_wlast && aw_len == 1)                                   
	      axi_wlast <= 1'b0;                                                            
	    else                                                                            
	      axi_wlast <= axi_wlast;                                                       
	  end                                                                               
	                                                                                    
	                                                                                    
	/* Burst length counter. Uses extra counter register bit to indicate terminal       
	 count to reduce decode logic */                                                    
	  always @(posedge CPU_M_AXI_ACLK)                                                      
	  begin                                                                             
	    if (rst_n == 0 || init_txn_pulse == 1'b1 || aw_len == 1'b1)    
	      begin                                                                         
	        write_index <= 0;                                                           
	      end                                                                           
	    else if (wnext && (write_index != aw_len-1))                         
	      begin                                                                         
	        write_index <= write_index + 1;                                             
	      end                                                                           
	    else                                                                            
	      write_index <= write_index;                                                   
	  end                                                                               

	//----------------------------
	//Write Response (B) Channel
	//----------------------------

	//The write response channel provides feedback that the write has committed
	//to memory. BREADY will occur when all of the data and the write address
	//has arrived and been accepted by the slave.

	//The write issuance (number of outstanding write addresses) is started by 
	//the Address Write transfer, and is completed by a BREADY/BRESP.

	//While negating BREADY will eventually throttle the AWREADY signal, 
	//it is best not to throttle the whole data channel this way.

	//The BRESP bit [1] is used indicate any errors from the interconnect or
	//slave for the entire write burst. This example will capture the error 
	//into the ERROR output. 

	  always @(posedge CPU_M_AXI_ACLK)                                     
	  begin                                                                 
	    if (rst_n == 0 || init_txn_pulse == 1'b1 )                                            
	      begin                                                             
	        axi_bready <= 1'b0;                                             
	      end                                                               
	    // accept/acknowledge bresp with axi_bready by the master           
	    // when CPU_BVALID is asserted by slave                           
	    else if (CPU_BVALID && ~axi_bready)                               
	      begin                                                             
	        axi_bready <= 1'b1;                                             
	      end                                                               
	    // deassert after one clock cycle                                   
	    else if (axi_bready)                                                
	      begin                                                             
	        axi_bready <= 1'b0;                                             
	      end                                                               
	    // retain the previous value                                        
	    else                                                                
	      axi_bready <= axi_bready;                                         
	  end                                                                   
	                                                                        
	//----------------------------
	//Read Address Channel
	//----------------------------

	//The Read Address Channel (AW) provides a similar function to the
	//Write Address channel- to provide the tranfer qualifiers for the burst.

	//In this example, the read address increments in the same
	//manner as the write address channel.

	  always @(posedge CPU_M_AXI_ACLK)                                 
	  begin                                                              
	                                                                     
	    if (rst_n == 0 || init_txn_pulse == 1'b1 )                                         
	      begin                                                          
	        axi_arvalid <= 1'b0;                                         
	      end                                                            
	    // If previously not valid , start next transaction              
	    else if (~axi_arvalid && start_single_burst_read)                
	      begin                                                          
	        axi_arvalid <= 1'b1;                                         
	      end                                                            
	    else if (CPU_ARREADY && axi_arvalid)                           
	      begin                                                          
	        axi_arvalid <= 1'b0;                                         
	      end                                                            
	    else                                                             
	      axi_arvalid <= axi_arvalid;                                    
	  end                                                                
	                                                          
	//--------------------------------
	//Read Data (and Response) Channel
	//--------------------------------

	 // Forward movement occurs when the channel is valid and ready   
	  assign rnext = CPU_RVALID && axi_rready;                                                                        
	// Burst length counter. Uses extra counter register bit to indicate    
	// terminal count to reduce decode logic                                
	  always @(posedge CPU_M_AXI_ACLK)                                          
	  begin                                                                 
	    if (rst_n == 0 || init_txn_pulse == 1'b1 || start_single_burst_read)                  
	      begin                                                             
	        read_index <= 0;                                                
	      end                                                               
	    else if (rnext && (read_index != ar_len-1))              
	      begin                                                             
	        read_index <= read_index + 1;                                   
	      end                                                               
	    else                                                                
	      read_index <= read_index;                                         
	  end                                                                                                                                           
	/*                                                                      
	 The Read Data channel returns the results of the read request          
	                                                                        
	 In this example the data checker is always able to accept              
	 more data, so no need to throttle the RREADY signal                    
	 */                                                                     
	  always @(posedge CPU_M_AXI_ACLK)                                          
	  begin                                                                 
	    if (rst_n == 0 || init_txn_pulse == 1'b1 )                  
	      begin                                                             
	        axi_rready <= 1'b0;                                             
	      end                                                               
	    // accept/acknowledge rdata/rresp with axi_rready by the master     
	    // when CPU_RVALID is asserted by slave                           
	    else if (CPU_RVALID)                       
	      begin                                      
	         if (CPU_RLAST && axi_rready)          
	          begin                                  
	            axi_rready <= 1'b0;                  
	          end                                    
	         else                                    
	           begin                                 
	            axi_rready <= 1'b1;                 
	           end                                   
	      end                                        
	    // retain the previous value                 
	  end                                            
	                                                                                                                                                                                                    	                                                                                                            	                                                                                                            
	  //implement master command interface state machine
	always @(posedge CPU_M_AXI_ACLK) begin
		if(rst_n == 1'b0) begin
			write_task<=1'b0;
			read_task<=1'b0;
			axi_wdata<=0;
			axi_awaddr<=0;
			axi_araddr<=0;
		end
		else begin
			if(init_txn_pulse == 1'b1 && write_task == 1'b1) write_task<=1'b0;
			else if(init_txn_pulse == 1'b1 && read_task == 1'b1) read_task<=1'b0;
			else if(WRITE_EN && ((axi_wdata !=WRITE_DATA)||(axi_awaddr!=WRITE_ADDRESS))) begin//ֹWRITE_ENʹڼظдͬһ
				write_task<=1'b1;
				axi_wdata <= WRITE_DATA;
				axi_awaddr<=WRITE_ADDRESS;
			end
			else if(READ_EN && (axi_araddr != READ_ADDRESS)) begin
				read_task<=1'b1;
				axi_araddr<=READ_ADDRESS;
			end
			else if(init_txn_pulse)begin
				 write_task<=1'b0;
				 read_task<=1'b0;
			end
			else ;
		end
	end                                                        
	                                                                                                            
	  always @ ( posedge CPU_M_AXI_ACLK) begin                                                                                                    
		if (rst_n == 1'b0 ) begin                                                                                               
	        // reset condition                                                                                  
	        // All the signals are assigned default values under reset condition                                
	        start_single_burst_write <= 1'b0;                                                                   
	        start_single_burst_read  <= 1'b0;                                                                     
	      end                                                                                                   
	    else begin                                                                                                                                                                                                                                                 
			if ( init_txn_pulse == 1'b1 && write_task == 1'b1) begin                                                                                                                                                                                                                                                                                           
				if (~axi_awvalid && ~start_single_burst_write && ~burst_write_active) start_single_burst_write <= 1'b1;                                                       
			end
			else start_single_burst_write <= 1'b0; //Negate to generate a pulse                                                                                                                                                                                                                                                                                                           
			if(init_txn_pulse == 1'b1 && read_task == 1'b1) begin                                                                
				if (~axi_arvalid && ~burst_read_active && ~start_single_burst_read) start_single_burst_read <= 1'b1;                                                                                                                                                                  
			end
			else start_single_burst_read <= 1'b0; //Negate to generate a pulse                                                                                                                                                                                        
	  	end //MASTER_EXECUTION_PROC                                                                               
	  end                                                                              
	                                                                                                            
	                                                                                                            
	  // burst_write_active signal is asserted when there is a burst write transaction                          
	  // is initiated by the assertion of start_single_burst_write. burst_write_active                          
	  // signal remains asserted until the burst write is accepted by the slave                                 
	  always @(posedge CPU_M_AXI_ACLK)                                                                              
	  begin                                                                                                     
	    if (rst_n == 0 || init_txn_pulse == 1'b1)                                                                                 
	      burst_write_active <= 1'b0;                                                                           
	                                                                                                            
	    //The burst_write_active is asserted when a write burst transaction is initiated                        
	    else if (start_single_burst_write)                                                                      
	      burst_write_active <= 1'b1;                                                                           
	    else if (CPU_BVALID && axi_bready)                                                                    
	      burst_write_active <= 0;                                                                              
	  end                                                                                                       
	                                                                                                            
	 // Check for last write completion.                                                                        
	                                                                                                            
	 // This logic is to qualify the last write count with the final write                                      
	 // response. This demonstrates how to confirm that a write has been                                        
	 // committed.                                                                                              
	                                                                                                            
	  always @(posedge CPU_M_AXI_ACLK)                                                                              
	  begin                                                                                                     
	    if (rst_n == 0 || init_txn_pulse == 1'b1)                                                                                 
	      writes_done <= 1'b0;                                                                                  
	                                                                                                            
	    //The writes_done should be associated with a bready response                                           
	    //else if (CPU_BVALID && axi_bready && (write_burst_counter == {(C_NO_BURSTS_REQ-1){1}}) && axi_wlast)
	    else if (CPU_BVALID && axi_bready)                          
	      writes_done <= 1'b1;                                                                                  
	    else                                                                                                    
	      writes_done <= 1'b0;                                                                           
	    end                                                                                                     
	                                                                                                            
	  // burst_read_active signal is asserted when there is a burst write transaction                           
	  // is initiated by the assertion of start_single_burst_write. start_single_burst_read                     
	  // signal remains asserted until the burst read is accepted by the master                                 
	  always @(posedge CPU_M_AXI_ACLK)                                                                              
	  begin                                                                                                     
	    if (rst_n == 0 || init_txn_pulse == 1'b1)                                                                                 
	      burst_read_active <= 1'b0;                                                                            
	                                                                                                            
	    //The burst_write_active is asserted when a write burst transaction is initiated                        
	    else if (start_single_burst_read)                                                                       
	      burst_read_active <= 1'b1;                                                                            
	    else if (CPU_RVALID && axi_rready && CPU_RLAST)                                                     
	      burst_read_active <= 0;                                                                               
	    end                                                                                                     
	                                                                                                            
	                                                                                                            
	 // Check for last read completion.                                                                         
	                                                                                                            
	 // This logic is to qualify the last read count with the final read                                        
	 // response. This demonstrates how to confirm that a read has been                                         
	 // committed.                                                                                              
	                                                                                                            
	  always @(posedge CPU_M_AXI_ACLK)                                                                              
	  begin                                                                                                     
	    if (rst_n == 0 || init_txn_pulse == 1'b1)                                                                                 
	      reads_done <= 1'b0;                                                                                   
	                                                                                                            
	    //The reads_done should be associated with a rready response                                            
	    //else if (CPU_BVALID && axi_bready && (write_burst_counter == {(C_NO_BURSTS_REQ-1){1}}) && axi_wlast)
	    else if (CPU_RVALID && axi_rready && (read_index == ar_len-1))
	      reads_done <= 1'b1;                                                                                   
	    else                                                                                                    
	      reads_done <= 1'b0;                                                                             
	    end                                                                                                     
	
	CPU CPU0(.clk(CPU_M_AXI_ACLK),.rst_n(rst_n),.WRITE_EN(WRITE_EN),.WRITE_ADDRESS(WRITE_ADDRESS),.WRITE_DATA(WRITE_DATA),.READ_EN(READ_EN),.READ_ADDRESS(READ_ADDRESS),.READ_DATA(READ_DATA),.CPU_WRITE_DONE(CPU_WRITE_DONE),.CPU_READ_DONE(CPU_READ_DONE));
	
	endmodule
