`timescale 1ns / 1ps
module CPU # (parameter DATA_WIDTH = 32)(
	input clk,
	input rst_n,
	output WRITE_EN,
	output [31:0] WRITE_ADDRESS,
	output [31:0] WRITE_DATA,
	output READ_EN,
	output [31:0] READ_ADDRESS,
	input [31:0] READ_DATA,
	input CPU_WRITE_DONE,
	input CPU_READ_DONE 
    );
  	 
  wire                    j, jr, branch;
  wire                    j_type,
								  j_type_ex,
								  j_type_mem,
								  j_type_wb;
  wire                    flush;//ˮ߳ˢ
  wire [DATA_WIDTH-1 : 0] lui_result_id,
                          lui_result_ex,
								  lui_result_mem,
								  lui_result_wb,
                          auipc_result_id,
								  auipc_result_ex,
								  auipc_result_mem,
								  auipc_result_wb,
								  lui_id,
								  lui_ex,
								  lui_mem,
								  lui_wb,
								  auipc_id,
								  auipc_ex,
								  auipc_mem,
								  auipc_wb;
  wire [DATA_WIDTH-1 : 0] branch_addr, jr_addr, jump_addr;
  wire [DATA_WIDTH-1 : 0] i_imm_id,
								  u_imm_id,
								  jump_offset_id,
								  b_offset_id,
								  store_offset_id;
  wire [4 : 0]            rs1_addr_id, 
								  rs2_addr_id, 
								  rd_addr_id;
  wire [DATA_WIDTH-1 : 0] rs1_data_id,
								  rs2_data_id;
  wire [DATA_WIDTH-1 : 0] oprand_a,
								  oprand_b_temp;
  reg  [DATA_WIDTH-1 : 0] oprand_b;
								  
								  
  wire [1:0]              forward_a,
								  forward_b;
								  
  //IF
  reg  [DATA_WIDTH-1 : 0] pc_in;
  wire [DATA_WIDTH-1 : 0] pc_out,
                          pc_out_id;
  wire [DATA_WIDTH-1 : 0] rs1_data_ex,
                          rs2_data_ex,
								  pc_out_ex;
  wire [DATA_WIDTH-1 : 0] i_imm_ex,
                       	  //b_offset_ex,
                          store_offset_ex;
                          //jump_offset_ex;
  wire ram_read_ex,
       ram_write_ex,
       regs_write_ex;
  wire [4 : 0] rd_addr_ex,
					rs1_addr_ex,
					rs2_addr_ex;
  wire [5 : 0] alu_op_ex;
  wire [2 : 0] load_type_ex;
  wire [1 : 0] store_type_ex;
  wire [1 : 0]	op_b_sel_ex;
  wire [DATA_WIDTH-1 : 0] alu_result_ex;
  wire [4 : 0] rs1_addr_mem,
               rs2_addr_mem,
               rd_addr_mem;
  wire [DATA_WIDTH-1 : 0] alu_result_mem,
								  rs2_data_mem,
								  alu_result_wb,
								  pc_out_mem;
  wire [2 : 0] load_type_mem;
  wire [1 : 0] store_type_mem;
  wire [DATA_WIDTH-1 : 0] mem_addr;
  wire ram_read_mem,
		 ram_write_mem,
		 regs_write_mem;
  reg read_en,
		write_en;
  wire [DATA_WIDTH-1 : 0] data_wb,
                          ram_out_wb,
                          regs_write_data,
								  pc_out_wb;
  wire [4 : 0] rs1_addr_wb,
               rs2_addr_wb,
               rd_addr_wb;
  wire ram_read_wb;
  wire flowline_en;
	//---------------------
	//test
	initial begin
		pc_in=0;
	end
	//---------------------

	assign flowline_en = (!(ram_read_mem | ram_write_mem))|CPU_WRITE_DONE|CPU_READ_DONE;//ڴRAMждҪܶڣ˴ʱҪͣˮ
	
	assign branch_addr = pc_out_id + b_offset_id;
	assign jr_addr     = rs1_data_id + i_imm_id;
	assign jump_addr   = pc_out_id + jump_offset_id;
	assign j_type      = j|jr;
	assign lui_result_id      = u_imm_id;
	assign auipc_result_id    = u_imm_id + pc_out_id;
  
  
	always@(*) begin
	 case({j, jr, branch})
		3'b000: pc_in = pc_out + 4;
		3'b001: pc_in = branch_addr;
		3'b010: pc_in = jr_addr;
		3'b100: pc_in = jump_addr;
		default: pc_in = 0;//ԭΪpc_in=0;
	 endcase
	end
  
  myreg cpu_pc (.clk(clk), .rst(rst_n), .en(flowline_en), .in(pc_in), .out(pc_out));//test
  //myreg cpu_pc (.clk(clk), .rst(flush), .en(pc_en), .in(pc_in), .out(pc_out)); //real
  wire [DATA_WIDTH-1 : 0] instruction_if;
  ROM cpu_rom (.addr(pc_out), .instruction(instruction_if));//ݵַȡֵ
  
  
  //IF to ID
  wire [DATA_WIDTH-1 : 0] instruction_id;
  myreg ins_trans(.clk(clk), .rst(rst_n), .en(flowline_en), .in(instruction_if), .out(instruction_id));
  myreg pc_out_trans(.clk(clk), .rst(rst_n), .en(flowline_en), .in(pc_out), .out(pc_out_id));
  //ID
  //Defination of the immediate number provided by instructions оԷdecoderģ
  assign i_imm_id         =   {{21{instruction_id[31]}},instruction_id[30:20]};
  assign jump_offset_id   =   {{13{instruction_id[31]}}, instruction_id[19:12], instruction_id[20], instruction_id[30:21]};
  assign b_offset_id      =   {{21{instruction_id[31]}}, instruction_id[7], instruction_id[30:25], instruction_id[11:8]};
  assign store_offset_id  =   {{21{instruction_id[31]}}, instruction_id[30:25],instruction_id[11:7]}; 
  assign u_imm_id         =   {instruction_id[31:12],{12{1'b0}}};
  //Control signals
  wire ram_read_id,ram_write_id,regs_write_id;
  wire [5 : 0] alu_op_id;
  wire [2 : 0] load_type_id;
  wire [1 : 0] store_type_id;
  wire [1 : 0]	op_b_sel_id;
  
  //Decoder	
  decoder cpu_decoder
    (
     .ins(instruction_id),
     .rs1_data(rs1_data_id),
     .rs2_data(rs2_data_id),
     .ram_read(ram_read_id),
     .ram_write(ram_write_id),
     .regs_write(regs_write_id),
     .J(j),
     .JR(jr),
	  .LUI(lui_id),
	  .AUIPC(auipc_id),
     .Branch(branch),
     .op_b_sel(op_b_sel_id),
     .load_type(load_type_id),
	  .store_type(store_type_id),
     .alu_op(alu_op_id),
	  .flush(flush)
    );
	
  //Registers and reg data

  assign rs1_addr_id = instruction_id[19:15];
  assign rs2_addr_id = instruction_id[24:20];
  assign rd_addr_id = instruction_id[11:7];

  Registers cpu_regs 
    (
		.clk(clk),
      .write_en(regs_write_wb), 
      .addr1(rs1_addr_id),
      .addr2(rs2_addr_id), 
      .write_addr(rd_addr_wb), 
      .data1(rs1_data_id), 
      .data2(rs2_data_id), 
      .write_data(regs_write_data)
    );

  //ID to EX
  //immediate trans
  

  myreg #(.REG_WIDTH(32)) imm_trans (.clk(clk), .rst(rst_n), .en(flowline_en), .in(i_imm_id), .out(i_imm_ex));//㣬¸ڻжΪˮԶͣ
  //myreg #(.REG_WIDTH(32)) jump_trans (.clk(clk), .rst(stall), .en(1'b1), .in(jump_offset_id), .out(jump_offset_ex));
  //myreg #(.REG_WIDTH(32)) b_trans (.clk(clk), .rst(stall), .en(1'b1), .in(b_offset_id), .out(b_offset_ex));
  myreg #(.REG_WIDTH(32)) store_trans (.clk(clk), .rst(rst_n), .en(flowline_en), .in(store_offset_id), .out(store_offset_ex));
  myreg #(.REG_WIDTH(32)) pc_out_id_ex(.clk(clk), .rst(rst_n), .en(flowline_en), .in(pc_out_id), .out(pc_out_ex));//test
  myreg #(.REG_WIDTH(1)) j_type_trans(.clk(clk), .rst(rst_n), .en(flowline_en), .in(j_type), .out(j_type_ex));
  myreg #(.REG_WIDTH(32)) lui_result_id_ex(.clk(clk), .rst(rst_n), .en(flowline_en), .in(lui_result_id), .out(lui_result_ex));
  myreg #(.REG_WIDTH(32)) auipc_result_id_ex(.clk(clk), .rst(rst_n), .en(flowline_en), .in(auipc_result_id), .out(auipc_result_ex));
  myreg #(.REG_WIDTH(1))  lui_id_ex(.clk(clk), .rst(rst_n), .en(flowline_en), .in(lui_id), .out(lui_ex));
  myreg #(.REG_WIDTH(1))  auipc_id_ex(.clk(clk), .rst(rst_n), .en(flowline_en), .in(auipc_id), .out(auipc_ex));
  //data trans
  
  myreg #(.REG_WIDTH(32)) rs1_data_id_ex (.clk(clk), .rst(rst_n), .en(flowline_en), .in(rs1_data_id), .out(rs1_data_ex));//stall
  myreg #(.REG_WIDTH(32)) rs2_data_id_ex (.clk(clk), .rst(rst_n), .en(flowline_en), .in(rs2_data_id), .out(rs2_data_ex));//stall
  myreg #(.REG_WIDTH(5)) rs1_addr_id_ex (.clk(clk), .rst(rst_n), .en(flowline_en), .in(rs1_addr_id), .out(rs1_addr_ex));//stall
  myreg #(.REG_WIDTH(5)) rs2_addr_id_ex (.clk(clk), .rst(rst_n), .en(flowline_en), .in(rs2_addr_id), .out(rs2_addr_ex));//stall
  myreg #(.REG_WIDTH(5))  rd_trans  (.clk(clk), .rst(rst_n), .en(flowline_en), .in(rd_addr_id), .out(rd_addr_ex));//stall

  //control signal trans
  
  
  myreg #(.REG_WIDTH(3)) load_type_trans1(.clk(clk), .rst(rst_n), .en(flowline_en), .in(load_type_id), .out(load_type_ex));
  myreg #(.REG_WIDTH(2)) store_type_trans1(.clk(clk), .rst(rst_n), .en(flowline_en), .in(store_type_id), .out(store_type_ex));
  myreg #(.REG_WIDTH(2)) op_sel_trans(.clk(clk), .rst(rst_n), .en(flowline_en), .in(op_b_sel_id), .out(op_b_sel_ex));
  myreg #(.REG_WIDTH(3)) handshake_id_ex (
	.clk(clk), 
	.rst(rst_n), 
	.en(flowline_en), 
	.in({ram_read_id, ram_write_id, regs_write_id}), 
	.out({ram_read_ex, ram_write_ex, regs_write_ex})
 );
  myreg #(.REG_WIDTH(6)) alu_op_trans(.clk(clk), .rst(1'b0), .en(flowline_en), .in(alu_op_id), .out(alu_op_ex));
  
  //EX
  //жǷҪתҪ
  forward cpu_forward
    (
      .regs_write_ex(regs_write_ex),
      .regs_write_mem(regs_write_mem),
      .regs_write_wb(regs_write_wb),
		.ram_read_mem(ram_read_mem),
      .rs1_addr_ex(rs1_addr_ex),
      .rs2_addr_ex(rs2_addr_ex),
      .rd_addr_mem(rd_addr_mem),
      .rd_addr_wb(rd_addr_wb),
      .forward_a(forward_a),
      .forward_b(forward_b)
   );
  mux4 alu_muxa
    (
      .sel(forward_a),
      .in0(rs1_data_ex),
      .in1(regs_write_data),
      .in2(alu_result_mem),
      .in3(ram_out_mem),
      .mux_out(oprand_a)
    );
	
	mux4 alu_muxb
    (
      .sel(forward_b),
      .in0(rs2_data_ex),
      .in1(regs_write_data),
      .in2(alu_result_mem),
      .in3(ram_out_mem),
      .mux_out(oprand_b_temp)
    );

  //choose the source of the oprands in alu.
  always@(*)
    case(op_b_sel_ex)
      2'b00: oprand_b = oprand_b_temp;
      2'b01: oprand_b = i_imm_ex;
      2'b10: oprand_b = store_offset_ex;
      default: oprand_b = 32'd0;
    endcase
  ALU cpu_alu(.opcode(alu_op_ex), .oprand_a(oprand_a), .oprand_b(oprand_b), .result(alu_result_ex));
  
  //EX to MEM
  
  myreg #(.REG_WIDTH(5)) rs1_addr_ex_mem (.clk(clk), .rst(rst_n), .en(flowline_en), .in(rs1_addr_ex), .out(rs1_addr_mem));
  myreg #(.REG_WIDTH(5)) rs2_addr_ex_mem (.clk(clk), .rst(rst_n), .en(flowline_en), .in(rs2_addr_ex), .out(rs2_addr_mem));
  myreg #(.REG_WIDTH(5)) rd_addr_ex_mem (.clk(clk), .rst(rst_n), .en(flowline_en), .in(rd_addr_ex), .out(rd_addr_mem));
  myreg #(.REG_WIDTH(32)) pc_out_ex_mem (.clk(clk), .rst(rst_n), .en(flowline_en), .in(pc_out_ex), .out(pc_out_mem));
  myreg #(.REG_WIDTH(1)) j_type_ex_mem (.clk(clk), .rst(rst_n), .en(flowline_en), .in(j_type_ex), .out(j_type_mem));
  myreg #(.REG_WIDTH(32)) lui_result_ex_mem(.clk(clk), .rst(rst_n), .en(flowline_en), .in(lui_result_ex), .out(lui_result_mem));
  myreg #(.REG_WIDTH(32)) auipc_result_ex_mem(.clk(clk), .rst(rst_n), .en(flowline_en), .in(auipc_result_ex), .out(auipc_result_mem));
  myreg #(.REG_WIDTH(1))  lui_ex_mem(.clk(clk), .rst(rst_n), .en(flowline_en), .in(lui_ex), .out(lui_mem));
  myreg #(.REG_WIDTH(1))  auipc_ex_mem(.clk(clk), .rst(rst_n), .en(flowline_en), .in(auipc_ex), .out(auipc_mem));
  //-- memݵļĴ
 
  myreg #(.REG_WIDTH(3)) load_type_ex_mem (.clk(clk), .rst(rst_n), .en(flowline_en), .in(load_type_ex), .out(load_type_mem));
  myreg #(.REG_WIDTH(2)) store_type_ex_mem (.clk(clk), .rst(rst_n), .en(flowline_en), .in(store_type_ex), .out(store_type_mem));

  //źŴ
  
  myreg #(.REG_WIDTH(3)) handshake_ex_mem
    (
      .clk(clk), 
      .rst(rst_n), 
      .en(flowline_en), 
      .in({ram_read_ex, ram_write_ex, regs_write_ex}), 
      .out({ram_read_mem, ram_write_mem, regs_write_mem})
    );
  
	 //data in rs2 may not be used in execution phase, and in this situation it would be used as the destination register of operation store. ⲻ̫ףrs2ʲôʱΪĿĴ?
	 myreg rs2_trans2 (.clk(clk), .rst(rst_n), .en(flowline_en), .in(rs2_data_ex), .out(rs2_data_mem));
	 //the alu_result is used to provide address of ram in operation load / store.
	 myreg addr_trans (.clk(clk), .rst(rst_n), .en(flowline_en), .in(alu_result_ex), .out(alu_result_mem));
	 
	//MEM
	wire [DATA_WIDTH-1 : 0] ram_in; 
	reg [DATA_WIDTH-1 : 0] ram_out_mem;
	reg clear_readen;//ڱ֤ڴжʱread_enֻһ
	reg clear_writeen;//ڱ֤ڴдʱwrite_enֻһ
	assign ram_in = rs2_data_mem;
	assign READ_EN = ram_read_mem;
	assign WRITE_EN = ram_write_mem;
	assign WRITE_ADDRESS = alu_result_mem;
	assign READ_ADDRESS = alu_result_mem;
	always @(*) begin
		if(READ_EN) begin
			case(load_type_mem)
			  3'b000: ram_out_mem = READ_DATA;//LW
			  3'b001: ram_out_mem = {{17{READ_DATA[15]}},READ_DATA[14 : 0]};//LH
			  3'b010: ram_out_mem = {{25{READ_DATA[7]}}, READ_DATA[6 : 0]};//LB
			  3'b011: ram_out_mem = {{24{1'b0}},READ_DATA[7:0]};//LBU
			  3'b100: ram_out_mem = {{16{1'b0}},READ_DATA[15:0]};//LHU
			  default: ram_out_mem = 32'h0;
			endcase
		end
	end
	assign WRITE_DATA = ram_in;
	 //MEM to WB
	
  myreg #(.REG_WIDTH(5)) rs1_addr_mem_wb (.clk(clk), .rst(rst_n), .en(flowline_en), .in(rs1_addr_mem), .out(rs1_addr_wb));
  myreg #(.REG_WIDTH(5)) rs2_addr_mem_wb (.clk(clk), .rst(rst_n), .en(flowline_en), .in(rs2_addr_mem), .out(rs2_addr_wb));
  myreg #(.REG_WIDTH(5)) rd_addr_mem_wb (.clk(clk), .rst(rst_n), .en(flowline_en), .in(rd_addr_mem), .out(rd_addr_wb));
  myreg #(.REG_WIDTH(32)) pc_out_mem_wb (.clk(clk), .rst(rst_n), .en(flowline_en), .in(pc_out_mem), .out(pc_out_wb));
  myreg #(.REG_WIDTH(1)) j_type_mem_wb (.clk(clk), .rst(rst_n), .en(flowline_en), .in(j_type_mem), .out(j_type_wb));
  myreg #(.REG_WIDTH(32)) lui_result_mem_wb(.clk(clk), .rst(rst_n), .en(flowline_en), .in(lui_result_mem), .out(lui_result_wb));
  myreg #(.REG_WIDTH(32)) auipc_result_mem_wb(.clk(clk), .rst(rst_n), .en(flowline_en), .in(auipc_result_mem), .out(auipc_result_wb));
  myreg #(.REG_WIDTH(1))  lui_mem_wb(.clk(clk), .rst(rst_n), .en(flowline_en), .in(lui_mem), .out(lui_wb));
  myreg #(.REG_WIDTH(1))  auipc_mem_wb(.clk(clk), .rst(rst_n), .en(flowline_en), .in(auipc_mem), .out(auipc_wb));
	// the alu_result is used to provide data which the registers are about to writing in.
	myreg result_mem_wb (.clk(clk), .rst(rst_n), .en(flowline_en), .in(alu_result_mem), .out(alu_result_wb));
   myreg ram_trans (.clk(clk), .rst(rst_n), .en(flowline_en), .in(ram_out_mem), .out(ram_out_wb));
	//Control signals of ram has been used in phase MEM, so in this phase we only have to transport the control signal of registers.
	myreg #(.REG_WIDTH(3)) handshake_mem_wb 
    (
     .clk(clk), 
     .rst(rst_n), 
     .en(flowline_en), 
     .in({ram_read_mem, ram_write_mem, regs_write_mem}), 
     .out({ram_read_wb, ram_write_wb, regs_write_wb})
    );
	 
	//WB
	//use ram_read to judge if the data is from ram.
	assign regs_write_data = (ram_read_wb===1'b1) ? ram_out_wb : (j_type_wb===1'b1) ? pc_out_wb+4 : (lui_wb===1'b1) ? lui_result_wb : (auipc_wb===1'b1) ? auipc_result_wb : alu_result_wb;
endmodule
