`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date:    11:15:37 02/18/2022 
// Design Name: 
// Module Name:    top 
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: 
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments: 
//
//////////////////////////////////////////////////////////////////////////////////
module AXI_BUS #(
	// Width of ID for for write address, write data, read address and read data
	parameter integer C_S_AXI_ID_WIDTH	= 1,
	// Width of S_AXI data bus
	parameter integer C_S_AXI_DATA_WIDTH	= 32,
	// Width of S_AXI address bus
	parameter integer C_S_AXI_ADDR_WIDTH	= 32,
	// Width of optional user defined signal in write address channel
	parameter integer C_S_AXI_AWUSER_WIDTH	= 1,
	// Width of optional user defined signal in read address channel
	parameter integer C_S_AXI_ARUSER_WIDTH	= 1,
	// Width of optional user defined signal in write data channel
	parameter integer C_S_AXI_WUSER_WIDTH	= 1,
	// Width of optional user defined signal in read data channel
	parameter integer C_S_AXI_RUSER_WIDTH	= 1,
	// Width of optional user defined signal in write response channel
	parameter integer C_S_AXI_BUSER_WIDTH	= 1,
	parameter  RAM_BASE_ADDR	= 32'h00000000,//RAMҪƫƵַ,RAM[i]ַΪ i<<2+RAM_BASE_ADDR
	parameter  CSB_BASE_ADDR   = 32'h00001000,//CSBҪƫƵַ,CSB[i]ַΪ i<<2+CSB_BASE_ADDR,ADDR[12]=1'b1;
	// Thread ID Width
	parameter integer C_M_AXI_ID_WIDTH	= 1,//,ͬһͬһŵ밴˳ִ,ִ֮˳ûҪ
	// Width of Address Bus
	parameter integer C_M_AXI_ADDR_WIDTH	= 32,
	// Width of Data Bus
	parameter integer C_M_AXI_DATA_WIDTH	= 32,
	// Width of User Write Address Bus
	parameter integer C_M_AXI_AWUSER_WIDTH	= 1,//û
	// Width of User Read Address Bus
	parameter integer C_M_AXI_ARUSER_WIDTH	= 1,//û
	// Width of User Write Data Bus
	parameter integer C_M_AXI_WUSER_WIDTH	= 1,//û
	// Width of User Read Data Bus
	parameter integer C_M_AXI_RUSER_WIDTH	= 1,//û
	// Width of User Response Bus
	parameter integer C_M_AXI_BUSER_WIDTH	= 1//û
)
( 
	input  clk,
	input  rst_n
);
	// Write Address ID
	wire [C_S_AXI_ID_WIDTH-1 : 0] NVDLA_S_AXI_AWID;
	// Write address
	wire [C_S_AXI_ADDR_WIDTH-1 : 0] NVDLA_S_AXI_AWADDR;
	// Burst length. The burst length gives the exact number of transfers in a burst
	wire [7 : 0] NVDLA_S_AXI_AWLEN;
	// Burst size. This signal indicates the size of each transfer in the burst
	wire [2 : 0] NVDLA_S_AXI_AWSIZE;
	// Burst type. The burst type and the size information, 
	// determine how the address for each transfer within the burst is calculated.
	wire [1 : 0] NVDLA_S_AXI_AWBURST;
	// Lock type. Provides additional information about the
	// atomic characteristics of the transfer.
	wire  NVDLA_S_AXI_AWLOCK;
	// Memory type. This signal indicates how transactions
	// are required to progress through a system.
	wire [3 : 0] NVDLA_S_AXI_AWCACHE;
	// Protection type. This signal indicates the privilege
	// and security level of the transaction, and whether
	// the transaction is a data access or an instruction access.
	wire [2 : 0] NVDLA_S_AXI_AWPROT;
	// Quality of Service, QoS identifier sent for each
	// write transaction.
	wire [3 : 0] NVDLA_S_AXI_AWQOS;
	// Region identifier. Permits a single physical interface
	// on a slave to be used for multiple logical interfaces.
	wire [3 : 0] NVDLA_S_AXI_AWREGION;
	// Optional User-defined signal in the write address channel.
	wire [C_S_AXI_AWUSER_WIDTH-1 : 0] NVDLA_S_AXI_AWUSER;
	// Write address valid. This signal indicates that
	// the channel is signaling valid write address and
	// control information.
	wire  NVDLA_S_AXI_AWVALID;
	// Write address ready. This signal indicates that
	// the slave is ready to accept an address and associated
	// control signals.
	wire  NVDLA_S_AXI_AWREADY;
	// Write Data
	wire [C_S_AXI_DATA_WIDTH-1 : 0] NVDLA_S_AXI_WDATA;
	// Write strobes. This signal indicates which byte
	// lanes hold valid data. There is one write strobe
	// bit for each eight bits of the write data bus.
	wire [(C_S_AXI_DATA_WIDTH/8)-1 : 0] NVDLA_S_AXI_WSTRB;
	// Write last. This signal indicates the last transfer
	// in a write burst.
	wire  NVDLA_S_AXI_WLAST;
	// Optional User-defined signal in the write data channel.
	wire [C_S_AXI_WUSER_WIDTH-1 : 0] NVDLA_S_AXI_WUSER;
	// Write valid. This signal indicates that valid write
	// data and strobes are available.
	wire  NVDLA_S_AXI_WVALID;
	// Write ready. This signal indicates that the slave
	// can accept the write data.
	wire  NVDLA_S_AXI_WREADY;
	// Response ID tag. This signal is the ID tag of the
	// write response.
	wire [C_S_AXI_ID_WIDTH-1 : 0] NVDLA_S_AXI_BID;
	// Write response. This signal indicates the status
	// of the write transaction.
	wire [1 : 0] NVDLA_S_AXI_BRESP;
	// Optional User-defined signal in the write response channel.
	wire [C_S_AXI_BUSER_WIDTH-1 : 0] NVDLA_S_AXI_BUSER;
	// Write response valid. This signal indicates that the
	// channel is signaling a valid write response.
	wire  NVDLA_S_AXI_BVALID;
	// Response ready. This signal indicates that the master
	// can accept a write response.
	wire  NVDLA_S_AXI_BREADY;
	// Read address ID. This signal is the identification
	// tag for the read address group of signals.
	wire [C_S_AXI_ID_WIDTH-1 : 0] NVDLA_S_AXI_ARID;
	// Read address. This signal indicates the initial
	// address of a read burst transaction.
	wire [C_S_AXI_ADDR_WIDTH-1 : 0] NVDLA_S_AXI_ARADDR;
	// Burst length. The burst length gives the exact number of transfers in a burst
	wire [7 : 0] NVDLA_S_AXI_ARLEN;
	// Burst size. This signal indicates the size of each transfer in the burst
	wire [2 : 0] NVDLA_S_AXI_ARSIZE;
	// Burst type. The burst type and the size information, 
	// determine how the address for each transfer within the burst is calculated.
	wire [1 : 0] NVDLA_S_AXI_ARBURST;
	// Lock type. Provides additional information about the
	// atomic characteristics of the transfer.
	wire  NVDLA_S_AXI_ARLOCK;
	// Memory type. This signal indicates how transactions
	// are required to progress through a system.
	wire [3 : 0] NVDLA_S_AXI_ARCACHE;
	// Protection type. This signal indicates the privilege
	// and security level of the transaction, and whether
	// the transaction is a data access or an instruction access.
	wire [2 : 0] NVDLA_S_AXI_ARPROT;
	// Quality of Service, QoS identifier sent for each
	// read transaction.
	wire [3 : 0] NVDLA_S_AXI_ARQOS;
	// Region identifier. Permits a single physical interface
	// on a slave to be used for multiple logical interfaces.
	wire [3 : 0] NVDLA_S_AXI_ARREGION;
	// Optional User-defined signal in the read address channel.
	wire [C_S_AXI_ARUSER_WIDTH-1 : 0] NVDLA_S_AXI_ARUSER;
	// Write address valid. This signal indicates that
	// the channel is signaling valid read address and
	// control information.
	wire  NVDLA_S_AXI_ARVALID;
	// Read address ready. This signal indicates that
	// the slave is ready to accept an address and associated
	// control signals.
	wire  NVDLA_S_AXI_ARREADY;
	// Read ID tag. This signal is the identification tag
	// for the read data group of signals generated by the slave.
	wire [C_S_AXI_ID_WIDTH-1 : 0] NVDLA_S_AXI_RID;
	// Read Data
	wire [C_S_AXI_DATA_WIDTH-1 : 0] NVDLA_S_AXI_RDATA;
	// Read response. This signal indicates the status of
	// the read transfer.
	wire [1 : 0] NVDLA_S_AXI_RRESP;
	// Read last. This signal indicates the last transfer
	// in a read burst.
	wire  NVDLA_S_AXI_RLAST;
	// Optional User-defined signal in the read address channel.
	wire [C_S_AXI_RUSER_WIDTH-1 : 0] NVDLA_S_AXI_RUSER;
	// Read valid. This signal indicates that the channel
	// is signaling the required read data.
	wire  NVDLA_S_AXI_RVALID;
	// Read ready. This signal indicates that the master can
	// accept the read data and response information.
	wire  NVDLA_S_AXI_RREADY;
	//ʾжϵź
	wire NVDLA2CORE_INTERRUPT;
	//DBBIFͨѶź
	// Global Clock Signal.
	wire  NVDLA_M_AXI_ACLK;
	// Master Interface Write Address ID
	wire [C_M_AXI_ID_WIDTH-1 : 0] NVDLA_M_AXI_AWID;
	// Master Interface Write Address
	wire [C_M_AXI_ADDR_WIDTH-1 : 0] NVDLA_M_AXI_AWADDR;
	// Burst length. The burst length gives the exact number of transfers in a burst
	wire [7 : 0] NVDLA_M_AXI_AWLEN;
	// Burst size. This signal indicates the size of each transfer in the burst
	wire [2 : 0] NVDLA_M_AXI_AWSIZE;
	// Burst type. The burst type and the size information, 
	// determine how the address for each transfer within the burst is calculated.
	wire [1 : 0] NVDLA_M_AXI_AWBURST;
	// Lock type. Provides additional information about the
	// atomic characteristics of the transfer.
	wire  NVDLA_M_AXI_AWLOCK;
	// Memory type. This signal indicates how transactions
	// are required to progress through a system.
	wire [3 : 0] NVDLA_M_AXI_AWCACHE;
	// Protection type. This signal indicates the privilege
	// and security level of the transaction, and whether
	// the transaction is a data access or an instruction access.
	wire [2 : 0] NVDLA_M_AXI_AWPROT;
	// Quality of Service, QoS identifier sent for each write transaction.
	wire [3 : 0] NVDLA_M_AXI_AWQOS;
	// Optional User-defined signal in the write address channel.
	wire [C_M_AXI_AWUSER_WIDTH-1 : 0] NVDLA_M_AXI_AWUSER;
	// Write address valid. This signal indicates that
	// the channel is signaling valid write address and control information.
	wire  NVDLA_M_AXI_AWVALID;
	// Write address ready. This signal indicates that
	// the slave is ready to accept an address and associated control signals
	wire  NVDLA_M_AXI_AWREADY;
	// Master Interface Write Data.
	wire [C_M_AXI_DATA_WIDTH-1 : 0] NVDLA_M_AXI_WDATA;
	// Write strobes. This signal indicates which byte
	// lanes hold valid data. There is one write strobe
	// bit for each eight bits of the write data bus.
	wire [C_M_AXI_DATA_WIDTH/8-1 : 0] NVDLA_M_AXI_WSTRB;
	// Write last. This signal indicates the last transfer in a write burst.
	wire  NVDLA_M_AXI_WLAST;
	// Optional User-defined signal in the write data channel.
	wire [C_M_AXI_WUSER_WIDTH-1 : 0] NVDLA_M_AXI_WUSER;
	// Write valid. This signal indicates that valid write
	// data and strobes are available
	wire  NVDLA_M_AXI_WVALID;
	// Write ready. This signal indicates that the slave
	// can accept the write data.
	wire  NVDLA_M_AXI_WREADY;
	// Master Interface Write Response.
	wire [C_M_AXI_ID_WIDTH-1 : 0] NVDLA_M_AXI_BID;
	// Write response. This signal indicates the status of the write transaction.
	wire [1 : 0] NVDLA_M_AXI_BRESP;
	// Optional User-defined signal in the write response channel
	wire [C_M_AXI_BUSER_WIDTH-1 : 0] NVDLA_M_AXI_BUSER;
	// Write response valid. This signal indicates that the
	// channel is signaling a valid write response.
	wire  NVDLA_M_AXI_BVALID;
	// Response ready. This signal indicates that the master
	// can accept a write response.
	wire  NVDLA_M_AXI_BREADY;
	// Master Interface Read Address.
	wire [C_M_AXI_ID_WIDTH-1 : 0] NVDLA_M_AXI_ARID;
	// Read address. This signal indicates the initial
	// address of a read burst transaction.
	wire [C_M_AXI_ADDR_WIDTH-1 : 0] NVDLA_M_AXI_ARADDR;
	// Burst length. The burst length gives the exact number of transfers in a burst
	wire [7 : 0] NVDLA_M_AXI_ARLEN;
	// Burst size. This signal indicates the size of each transfer in the burst
	wire [2 : 0] NVDLA_M_AXI_ARSIZE;
	// Burst type. The burst type and the size information, 
	// determine how the address for each transfer within the burst is calculated.
	wire [1 : 0] NVDLA_M_AXI_ARBURST;
	// Lock type. Provides additional information about the
	// atomic characteristics of the transfer.
	wire  NVDLA_M_AXI_ARLOCK;
	// Memory type. This signal indicates how transactions
	// are required to progress through a system.
	wire [3 : 0] NVDLA_M_AXI_ARCACHE;
	// Protection type. This signal indicates the privilege
	// and security level of the transaction, and whether
	// the transaction is a data access or an instruction access.
	wire [2 : 0] NVDLA_M_AXI_ARPROT;
	// Quality of Service, QoS identifier sent for each read transaction
	wire [3 : 0] NVDLA_M_AXI_ARQOS;
	// Optional User-defined signal in the read address channel.
	wire [C_M_AXI_ARUSER_WIDTH-1 : 0] NVDLA_M_AXI_ARUSER;
	// Write address valid. This signal indicates that
	// the channel is signaling valid read address and control information
	wire  NVDLA_M_AXI_ARVALID;
	// Read address ready. This signal indicates that
	// the slave is ready to accept an address and associated control signals
	wire  NVDLA_M_AXI_ARREADY;
	// Read ID tag. This signal is the identification tag
	// for the read data group of signals generated by the slave.
	wire [C_M_AXI_ID_WIDTH-1 : 0] NVDLA_M_AXI_RID;
	// Master Read Data
	wire [C_M_AXI_DATA_WIDTH-1 : 0] NVDLA_M_AXI_RDATA;
	// Read response. This signal indicates the status of the read transfer
	wire [1 : 0] NVDLA_M_AXI_RRESP;
	// Read last. This signal indicates the last transfer in a read burst
	wire  NVDLA_M_AXI_RLAST;
	// Optional User-defined signal in the read address channel.
	wire [C_M_AXI_RUSER_WIDTH-1 : 0] NVDLA_M_AXI_RUSER;
	// Read valid. This signal indicates that the channel
	// is signaling the required read data.
	wire  NVDLA_M_AXI_RVALID;
	// Read ready. This signal indicates that the master can
	// accept the read data and response information.
	wire  NVDLA_M_AXI_RREADY;
	// Write Address ID
	wire [C_S_AXI_ID_WIDTH-1 : 0] RAM_S_AXI_AWID;
	// Write address
	wire [C_S_AXI_ADDR_WIDTH-1 : 0] RAM_S_AXI_AWADDR;
	// Burst length. The burst length gives the exact number of transfers in a burst
	wire [7 : 0] RAM_S_AXI_AWLEN;
	// Burst size. This signal indicates the size of each transfer in the burst
	wire [2 : 0] RAM_S_AXI_AWSIZE;
	// Burst type. The burst type and the size information, 
	// determine how the address for each transfer within the burst is calculated.
	wire [1 : 0] RAM_S_AXI_AWBURST;
	// Lock type. Provides additional information about the
	// atomic characteristics of the transfer.
	wire RAM_S_AXI_AWLOCK;
	// Memory type. This signal indicates how transactions
	// are required to progress through a system.
	wire [3 : 0] RAM_S_AXI_AWCACHE;
	// Protection type. This signal indicates the privilege
	// and security level of the transaction, and whether
	// the transaction is a data access or an instruction access.
	wire [2 : 0] RAM_S_AXI_AWPROT;
	// Quality of Service, QoS identifier sent for each
	// write transaction.
	wire [3 : 0] RAM_S_AXI_AWQOS;
	// Region identifier. Permits a single physical interface
	// on a slave to be used for multiple logical interfaces.
	wire [3 : 0] RAM_S_AXI_AWREGION;
	// Optional User-defined signal in the write address channel.
	wire [C_S_AXI_AWUSER_WIDTH-1 : 0] RAM_S_AXI_AWUSER;
	// Write address valid. This signal indicates that
	// the channel is signaling valid write address and
	// control information.
	wire  RAM_S_AXI_AWVALID;
	// Write address ready. This signal indicates that
	// the slave is ready to accept an address and associated
	// control signals.
	wire  RAM_S_AXI_AWREADY;
	// Write Data
	wire [C_S_AXI_DATA_WIDTH-1 : 0] RAM_S_AXI_WDATA;
	// Write strobes. This signal indicates which byte
	// lanes hold valid data. There is one write strobe
	// bit for each eight bits of the write data bus.
	wire [(C_S_AXI_DATA_WIDTH/8)-1 : 0] RAM_S_AXI_WSTRB;
	// Write last. This signal indicates the last transfer
	// in a write burst.
	wire  RAM_S_AXI_WLAST;
	// Optional User-defined signal in the write data channel.
	wire [C_S_AXI_WUSER_WIDTH-1 : 0] RAM_S_AXI_WUSER;
	// Write valid. This signal indicates that valid write
	// data and strobes are available.
	wire  RAM_S_AXI_WVALID;
	// Write ready. This signal indicates that the slave
	// can accept the write data.
	wire  RAM_S_AXI_WREADY;
	// Response ID tag. This signal is the ID tag of the
	// write response.
	wire [C_S_AXI_ID_WIDTH-1 : 0] RAM_S_AXI_BID;
	// Write response. This signal indicates the status
	// of the write transaction.
	wire [1 : 0] RAM_S_AXI_BRESP;
	// Optional User-defined signal in the write response channel.
	wire [C_S_AXI_BUSER_WIDTH-1 : 0] RAM_S_AXI_BUSER;
	// Write response valid. This signal indicates that the
	// channel is signaling a valid write response.
	wire  RAM_S_AXI_BVALID;
	// Response ready. This signal indicates that the master
	// can accept a write response.
	wire  RAM_S_AXI_BREADY;
	// Read address ID. This signal is the identification
	// tag for the read address group of signals.
	wire [C_S_AXI_ID_WIDTH-1 : 0] RAM_S_AXI_ARID;
	// Read address. This signal indicates the initial
	// address of a read burst transaction.
	wire [C_S_AXI_ADDR_WIDTH-1 : 0] RAM_S_AXI_ARADDR;
	// Burst length. The burst length gives the exact number of transfers in a burst
	wire [7 : 0] RAM_S_AXI_ARLEN;
	// Burst size. This signal indicates the size of each transfer in the burst
	wire [2 : 0] RAM_S_AXI_ARSIZE;
	// Burst type. The burst type and the size information, 
	// determine how the address for each transfer within the burst is calculated.
	wire [1 : 0] RAM_S_AXI_ARBURST;
	// Lock type. Provides additional information about the
	// atomic characteristics of the transfer.
	wire RAM_S_AXI_ARLOCK;
	// Memory type. This signal indicates how transactions
	// are required to progress through a system.
	wire [3 : 0] RAM_S_AXI_ARCACHE;
	// Protection type. This signal indicates the privilege
	// and security level of the transaction, and whether
	// the transaction is a data access or an instruction access.
	wire [2 : 0] RAM_S_AXI_ARPROT;
	// Quality of Service, QoS identifier sent for each
	// read transaction.
	wire [3 : 0] RAM_S_AXI_ARQOS;
	// Region identifier. Permits a single physical interface
	// on a slave to be used for multiple logical interfaces.
	wire [3 : 0] RAM_S_AXI_ARREGION;
	// Optional User-defined signal in the read address channel.
	wire [C_S_AXI_ARUSER_WIDTH-1 : 0] RAM_S_AXI_ARUSER;
	// Write address valid. This signal indicates that
	// the channel is signaling valid read address and
	// control information.
	wire  RAM_S_AXI_ARVALID;
	// Read address ready. This signal indicates that
	// the slave is ready to accept an address and associated
	// control signals.
	wire  RAM_S_AXI_ARREADY;
	// Read ID tag. This signal is the identification tag
	// for the read data group of signals generated by the slave.
	wire [C_S_AXI_ID_WIDTH-1 : 0] RAM_S_AXI_RID;
	// Read Data
	wire [C_S_AXI_DATA_WIDTH-1 : 0] RAM_S_AXI_RDATA;
	// Read response. This signal indicates the status of
	// the read transfer.
	wire [1 : 0] RAM_S_AXI_RRESP;
	// Read last. This signal indicates the last transfer
	// in a read burst.
	wire  RAM_S_AXI_RLAST;
	// Optional User-defined signal in the read address channel.
	wire [C_S_AXI_RUSER_WIDTH-1 : 0] RAM_S_AXI_RUSER;
	// Read valid. This signal indicates that the channel
	// is signaling the required read data.
	wire  RAM_S_AXI_RVALID;
	// Read ready. This signal indicates that the master can
	// accept the read data and response information.
	wire  RAM_S_AXI_RREADY;
	// Master Interface Write Address ID
	wire [C_M_AXI_ID_WIDTH-1 : 0] CPU_AWID;
	// Master Interface Write Address
	wire [C_M_AXI_ADDR_WIDTH-1 : 0] CPU_AWADDR;
	// Burst length. The burst length gives the exact number of transfers in a burst
	wire [7 : 0] CPU_AWLEN;
	// Burst size. This signal indicates the size of each transfer in the burst
	wire [2 : 0] CPU_AWSIZE;
	// Burst type. The burst type and the size information, 
	// determine how the address for each transfer within the burst is calculated.
	wire [1 : 0] CPU_AWBURST;
	// Lock type. Provides additional information about the
	// atomic characteristics of the transfer.
	wire  CPU_AWLOCK;
	// Memory type. This signal indicates how transactions
	// are required to progress through a system.
	wire [3 : 0] CPU_AWCACHE;
	// Protection type. This signal indicates the privilege
	// and security level of the transaction, and whether
	// the transaction is a data access or an instruction access.
	wire [2 : 0] CPU_AWPROT;
	// Quality of Service, QoS identifier sent for each write transaction.
	wire [3 : 0] CPU_AWQOS;
	// Optional User-defined signal in the write address channel.
	wire [C_M_AXI_AWUSER_WIDTH-1 : 0] CPU_AWUSER;
	// Write address valid. This signal indicates that
	// the channel is signaling valid write address and control information.
	wire  CPU_AWVALID;
	// Write address ready. This signal indicates that
	// the slave is ready to accept an address and associated control signals
	wire  CPU_AWREADY;
	// Master Interface Write Data.
	wire [C_M_AXI_DATA_WIDTH-1 : 0] CPU_WDATA;
	// Write strobes. This signal indicates which byte
	// lanes hold valid data. There is one write strobe
	// bit for each eight bits of the write data bus.
	wire [C_M_AXI_DATA_WIDTH/8-1 : 0] CPU_WSTRB;
	// Write last. This signal indicates the last transfer in a write burst.
	wire  CPU_WLAST;
	// Optional User-defined signal in the write data channel.
	wire [C_M_AXI_WUSER_WIDTH-1 : 0] CPU_WUSER;
	// Write valid. This signal indicates that valid write
	// data and strobes are available
	wire  CPU_WVALID;
	// Write ready. This signal indicates that the slave
	// can accept the write data.
	wire  CPU_WREADY;
	// Master Interface Write Response.
	wire [C_M_AXI_ID_WIDTH-1 : 0] CPU_BID;
	// Write response. This signal indicates the status of the write transaction.
	wire [1 : 0] CPU_BRESP;
	// Optional User-defined signal in the write response channel
	wire [C_M_AXI_BUSER_WIDTH-1 : 0] CPU_BUSER;
	// Write response valid. This signal indicates that the
	// channel is signaling a valid write response.
	wire  CPU_BVALID;
	// Response ready. This signal indicates that the master
	// can accept a write response.
	wire  CPU_BREADY;
	// Master Interface Read Address.
	wire [C_M_AXI_ID_WIDTH-1 : 0] CPU_ARID;
	// Read address. This signal indicates the initial
	// address of a read burst transaction.
	wire [C_M_AXI_ADDR_WIDTH-1 : 0] CPU_ARADDR;
	// Burst length. The burst length gives the exact number of transfers in a burst
	wire [7 : 0] CPU_ARLEN;
	// Burst size. This signal indicates the size of each transfer in the burst
	wire [2 : 0] CPU_ARSIZE;
	// Burst type. The burst type and the size information, 
	// determine how the address for each transfer within the burst is calculated.
	wire [1 : 0] CPU_ARBURST;
	// Lock type. Provides additional information about the
	// atomic characteristics of the transfer.
	wire  CPU_ARLOCK;
	// Memory type. This signal indicates how transactions
	// are required to progress through a system.
	wire [3 : 0] CPU_ARCACHE;
	// Protection type. This signal indicates the privilege
	// and security level of the transaction, and whether
	// the transaction is a data access or an instruction access.
	wire [2 : 0] CPU_ARPROT;
	// Quality of Service, QoS identifier sent for each read transaction
	wire [3 : 0] CPU_ARQOS;
	// Optional User-defined signal in the read address channel.
	wire [C_M_AXI_ARUSER_WIDTH-1 : 0] CPU_ARUSER;
	// Write address valid. This signal indicates that
	// the channel is signaling valid read address and control information
	wire  CPU_ARVALID;
	// Read address ready. This signal indicates that
	// the slave is ready to accept an address and associated control signals
	wire  CPU_ARREADY;
	// Read ID tag. This signal is the identification tag
	// for the read data group of signals generated by the slave.
	wire [C_M_AXI_ID_WIDTH-1 : 0] CPU_RID;
	// Master Read Data
	wire [C_M_AXI_DATA_WIDTH-1 : 0] CPU_RDATA;
	// Read response. This signal indicates the status of the read transfer
	wire [1 : 0] CPU_RRESP;
	// Read last. This signal indicates the last transfer in a read burst
	wire  CPU_RLAST;
	// Optional User-defined signal in the read address channel.
	wire [C_M_AXI_RUSER_WIDTH-1 : 0] CPU_RUSER;
	// Read valid. This signal indicates that the channel
	// is signaling the required read data.
	wire  CPU_RVALID;
	// Read ready. This signal indicates that the master can
	// accept the read data and response information.
	wire  CPU_RREADY;
	
	assign NVDLA_S_AXI_AWVALID = NVDLA_M_AXI_AWVALID | CPU_AWVALID;
	assign NVDLA_S_AXI_AWID = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWID :(CPU_AWVALID) ? CPU_AWID : 0;
	assign NVDLA_S_AXI_AWADDR = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWADDR :(CPU_AWVALID) ? CPU_AWADDR : 0;
	assign NVDLA_S_AXI_AWLEN = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWLEN :(CPU_AWVALID) ? CPU_AWLEN : 0;
	assign NVDLA_S_AXI_AWSIZE = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWSIZE :(CPU_AWVALID) ? CPU_AWSIZE : 0;
	assign NVDLA_S_AXI_AWBURST = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWBURST :(CPU_AWVALID) ? CPU_AWBURST : 0;
	assign NVDLA_S_AXI_AWLOCK = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWLOCK :(CPU_AWVALID) ? CPU_AWLOCK : 0;
	assign NVDLA_S_AXI_AWCACHE = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWCACHE :(CPU_AWVALID) ? CPU_AWCACHE : 0;
	assign NVDLA_S_AXI_AWPROT = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWPROT :(CPU_AWVALID) ? CPU_AWPROT : 0;
	assign NVDLA_S_AXI_AWQOS = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWQOS :(CPU_AWVALID) ? CPU_AWQOS : 0;
	assign NVDLA_S_AXI_AWUSER = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWUSER :(CPU_AWVALID) ? CPU_AWUSER : 0;
	assign NVDLA_S_AXI_WVALID = NVDLA_M_AXI_WVALID | CPU_WVALID;
	assign NVDLA_S_AXI_WDATA = (NVDLA_M_AXI_WVALID) ? NVDLA_M_AXI_WDATA : (CPU_WVALID) ? CPU_WDATA : 0;
	assign NVDLA_S_AXI_WSTRB = (NVDLA_M_AXI_WVALID) ? NVDLA_M_AXI_WSTRB : (CPU_WVALID) ? CPU_WSTRB : 0;
	assign NVDLA_S_AXI_WLAST = (NVDLA_M_AXI_WVALID) ? NVDLA_M_AXI_WLAST : (CPU_WVALID) ? CPU_WLAST : 0;
	assign NVDLA_S_AXI_WUSER = (NVDLA_M_AXI_WVALID) ? NVDLA_M_AXI_WUSER : (CPU_WVALID) ? CPU_WUSER : 0;
	assign NVDLA_S_AXI_BREADY = NVDLA_M_AXI_BREADY | CPU_BREADY;
	assign NVDLA_S_AXI_ARVALID = NVDLA_M_AXI_ARVALID | CPU_ARVALID;
	assign NVDLA_S_AXI_ARID = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARID : (CPU_ARVALID) ? CPU_ARID : 0;
	assign NVDLA_S_AXI_ARADDR = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARADDR : (CPU_ARVALID) ? CPU_ARADDR : 0;
	assign NVDLA_S_AXI_ARLEN = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARLEN : (CPU_ARVALID) ? CPU_ARLEN : 0;
	assign NVDLA_S_AXI_ARSIZE = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARSIZE : (CPU_ARVALID) ? CPU_ARSIZE : 0;
	assign NVDLA_S_AXI_ARBURST = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARBURST : (CPU_ARVALID) ? CPU_ARBURST : 0;
	assign NVDLA_S_AXI_ARLOCK = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARLOCK : (CPU_ARVALID) ? CPU_ARLOCK : 0;
	assign NVDLA_S_AXI_ARCACHE = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARCACHE : (CPU_ARVALID) ? CPU_ARCACHE : 0;
	assign NVDLA_S_AXI_ARPROT = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARPROT : (CPU_ARVALID) ? CPU_ARPROT : 0;
	assign NVDLA_S_AXI_ARQOS = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARQOS : (CPU_ARVALID) ? CPU_ARQOS : 0;
	assign NVDLA_S_AXI_ARUSER = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARUSER : (CPU_ARVALID) ? CPU_ARUSER : 0;
	assign NVDLA_S_AXI_RREADY = NVDLA_M_AXI_RREADY | CPU_RREADY;
	assign NVDLA_M_AXI_AWREADY = NVDLA_S_AXI_AWREADY | RAM_S_AXI_AWREADY;
	assign NVDLA_M_AXI_WREADY = NVDLA_S_AXI_WREADY | RAM_S_AXI_WREADY;
	assign NVDLA_M_AXI_BVALID = NVDLA_S_AXI_BVALID | RAM_S_AXI_BVALID;
	assign NVDLA_M_AXI_BID = (NVDLA_S_AXI_BVALID) ? NVDLA_S_AXI_BID : (RAM_S_AXI_BVALID) ? RAM_S_AXI_BID : 0;
	assign NVDLA_M_AXI_BRESP = (NVDLA_S_AXI_BVALID) ? NVDLA_S_AXI_BRESP : (RAM_S_AXI_BVALID) ? RAM_S_AXI_BRESP: 0;
	assign NVDLA_M_AXI_BUSER = (NVDLA_S_AXI_BVALID) ? NVDLA_S_AXI_BUSER : (RAM_S_AXI_BVALID) ? RAM_S_AXI_BUSER: 0;
	assign NVDLA_M_AXI_ARREADY = NVDLA_S_AXI_ARREADY | RAM_S_AXI_ARREADY;
	assign NVDLA_M_AXI_RVALID = NVDLA_S_AXI_RVALID | RAM_S_AXI_RVALID;
	assign NVDLA_M_AXI_RID = (NVDLA_S_AXI_RVALID) ? NVDLA_S_AXI_RID : (RAM_S_AXI_RVALID) ? RAM_S_AXI_RID : 0;
	assign NVDLA_M_AXI_RDATA = (NVDLA_S_AXI_RVALID) ? NVDLA_S_AXI_RDATA : (RAM_S_AXI_RVALID) ? RAM_S_AXI_RDATA : 0;
	assign NVDLA_M_AXI_RRESP = (NVDLA_S_AXI_RVALID) ? NVDLA_S_AXI_RRESP : (RAM_S_AXI_RVALID) ? RAM_S_AXI_RRESP : 0;
	assign NVDLA_M_AXI_RLAST = (NVDLA_S_AXI_RVALID) ? NVDLA_S_AXI_RLAST : (RAM_S_AXI_RVALID) ? RAM_S_AXI_RLAST : 0;
	assign NVDLA_M_AXI_RUSER = (NVDLA_S_AXI_RVALID) ? NVDLA_S_AXI_RUSER : (RAM_S_AXI_RVALID) ? RAM_S_AXI_RUSER : 0;
	assign RAM_S_AXI_AWVALID = NVDLA_M_AXI_AWVALID | CPU_AWVALID;
	assign RAM_S_AXI_AWID = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWID :(CPU_AWVALID) ? CPU_AWID : 0;
	assign RAM_S_AXI_AWADDR = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWADDR :(CPU_AWVALID) ? CPU_AWADDR : 0;
	assign RAM_S_AXI_AWLEN = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWLEN :(CPU_AWVALID) ? CPU_AWLEN : 0;
	assign RAM_S_AXI_AWSIZE = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWSIZE :(CPU_AWVALID) ? CPU_AWSIZE : 0;
	assign RAM_S_AXI_AWBURST = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWBURST :(CPU_AWVALID) ? CPU_AWBURST : 0;
	assign RAM_S_AXI_AWLOCK = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWLOCK :(CPU_AWVALID) ? CPU_AWLOCK : 0;
	assign RAM_S_AXI_AWCACHE = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWCACHE :(CPU_AWVALID) ? CPU_AWCACHE : 0;
	assign RAM_S_AXI_AWPROT = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWPROT :(CPU_AWVALID) ? CPU_AWPROT : 0;
	assign RAM_S_AXI_AWQOS = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWQOS :(CPU_AWVALID) ? CPU_AWQOS : 0;
	assign RAM_S_AXI_AWUSER = (NVDLA_M_AXI_AWVALID) ? NVDLA_M_AXI_AWUSER :(CPU_AWVALID) ? CPU_AWUSER : 0;
	assign RAM_S_AXI_WVALID = NVDLA_M_AXI_WVALID | CPU_WVALID;
	assign RAM_S_AXI_WDATA = (NVDLA_M_AXI_WVALID) ? NVDLA_M_AXI_WDATA : (CPU_WVALID) ? CPU_WDATA : 0;
	assign RAM_S_AXI_WSTRB = (NVDLA_M_AXI_WVALID) ? NVDLA_M_AXI_WSTRB : (CPU_WVALID) ? CPU_WSTRB : 0;
	assign RAM_S_AXI_WLAST = (NVDLA_M_AXI_WVALID) ? NVDLA_M_AXI_WLAST : (CPU_WVALID) ? CPU_WLAST : 0;
	assign RAM_S_AXI_WUSER = (NVDLA_M_AXI_WVALID) ? NVDLA_M_AXI_WUSER : (CPU_WVALID) ? CPU_WUSER : 0;
	assign RAM_S_AXI_BREADY = NVDLA_M_AXI_BREADY | CPU_BREADY;
	assign RAM_S_AXI_ARVALID = NVDLA_M_AXI_ARVALID | CPU_ARVALID;
	assign RAM_S_AXI_ARID = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARID : (CPU_ARVALID) ? CPU_ARID : 0;
	assign RAM_S_AXI_ARADDR = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARADDR : (CPU_ARVALID) ? CPU_ARADDR : 0;
	assign RAM_S_AXI_ARLEN = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARLEN : (CPU_ARVALID) ? CPU_ARLEN : 0;
	assign RAM_S_AXI_ARSIZE = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARSIZE : (CPU_ARVALID) ? CPU_ARSIZE : 0;
	assign RAM_S_AXI_ARBURST = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARBURST : (CPU_ARVALID) ? CPU_ARBURST : 0;
	assign RAM_S_AXI_ARLOCK = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARLOCK : (CPU_ARVALID) ? CPU_ARLOCK : 0;
	assign RAM_S_AXI_ARCACHE = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARCACHE : (CPU_ARVALID) ? CPU_ARCACHE : 0;
	assign RAM_S_AXI_ARPROT = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARPROT : (CPU_ARVALID) ? CPU_ARPROT : 0;
	assign RAM_S_AXI_ARQOS = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARQOS : (CPU_ARVALID) ? CPU_ARQOS : 0;
	assign RAM_S_AXI_ARUSER = (NVDLA_M_AXI_ARVALID) ? NVDLA_M_AXI_ARUSER : (CPU_ARVALID) ? CPU_ARUSER : 0;
	assign RAM_S_AXI_RREADY = NVDLA_M_AXI_RREADY | CPU_RREADY;
	assign CPU_AWREADY = NVDLA_S_AXI_AWREADY | RAM_S_AXI_AWREADY;
	assign CPU_WREADY = NVDLA_S_AXI_WREADY | RAM_S_AXI_WREADY;
	assign CPU_BVALID = NVDLA_S_AXI_BVALID | RAM_S_AXI_BVALID;
	assign CPU_BID = (NVDLA_S_AXI_BVALID) ? NVDLA_S_AXI_BID : (RAM_S_AXI_BVALID) ? RAM_S_AXI_BID : 0;
	assign CPU_BRESP = (NVDLA_S_AXI_BVALID) ? NVDLA_S_AXI_BRESP : (RAM_S_AXI_BVALID) ? RAM_S_AXI_BRESP: 0;
	assign CPU_BUSER = (NVDLA_S_AXI_BVALID) ? NVDLA_S_AXI_BUSER : (RAM_S_AXI_BVALID) ? RAM_S_AXI_BUSER: 0;
	assign CPU_ARREADY = NVDLA_S_AXI_ARREADY | RAM_S_AXI_ARREADY;
	assign CPU_RVALID = NVDLA_S_AXI_RVALID | RAM_S_AXI_RVALID;
	assign CPU_RID = (NVDLA_S_AXI_RVALID) ? NVDLA_S_AXI_RID : (RAM_S_AXI_RVALID) ? RAM_S_AXI_RID : 0;
	assign CPU_RDATA = (NVDLA_S_AXI_RVALID) ? NVDLA_S_AXI_RDATA : (RAM_S_AXI_RVALID) ? RAM_S_AXI_RDATA : 0;
	assign CPU_RRESP = (NVDLA_S_AXI_RVALID) ? NVDLA_S_AXI_RRESP : (RAM_S_AXI_RVALID) ? RAM_S_AXI_RRESP : 0;
	assign CPU_RLAST = (NVDLA_S_AXI_RVALID) ? NVDLA_S_AXI_RLAST : (RAM_S_AXI_RVALID) ? RAM_S_AXI_RLAST : 0;
	assign CPU_RUSER = (NVDLA_S_AXI_RVALID) ? NVDLA_S_AXI_RUSER : (RAM_S_AXI_RVALID) ? RAM_S_AXI_RUSER : 0;

	NVDLA_CONTROL NVDLA0(
		.NVDLA_S_AXI_ACLK(clk),
		.NVDLA_S_AXI_ARESETN(rst_n),
		.NVDLA_S_AXI_AWID(NVDLA_S_AXI_AWID),
		.NVDLA_S_AXI_AWADDR(NVDLA_S_AXI_AWADDR),
		.NVDLA_S_AXI_AWLEN(NVDLA_S_AXI_AWLEN),
		.NVDLA_S_AXI_AWSIZE(NVDLA_S_AXI_AWSIZE),
		.NVDLA_S_AXI_AWBURST(NVDLA_S_AXI_AWBURST),
		.NVDLA_S_AXI_AWLOCK(NVDLA_S_AXI_AWLOCK),
		.NVDLA_S_AXI_AWCACHE(NVDLA_S_AXI_AWCACHE),
		.NVDLA_S_AXI_AWPROT(NVDLA_S_AXI_AWPROT),
		.NVDLA_S_AXI_AWQOS(NVDLA_S_AXI_AWQOS),
		.NVDLA_S_AXI_AWREGION(NVDLA_S_AXI_AWREGION),
		.NVDLA_S_AXI_AWUSER(NVDLA_S_AXI_AWUSER),
		.NVDLA_S_AXI_AWVALID(NVDLA_S_AXI_AWVALID),
		.NVDLA_S_AXI_AWREADY(NVDLA_S_AXI_AWREADY),
		.NVDLA_S_AXI_WDATA(NVDLA_S_AXI_WDATA),
		.NVDLA_S_AXI_WSTRB(NVDLA_S_AXI_WSTRB),
		.NVDLA_S_AXI_WLAST(NVDLA_S_AXI_WLAST),
		.NVDLA_S_AXI_WUSER(NVDLA_S_AXI_WUSER),
		.NVDLA_S_AXI_WVALID(NVDLA_S_AXI_WVALID),
		.NVDLA_S_AXI_WREADY(NVDLA_S_AXI_WREADY),
		.NVDLA_S_AXI_BID(NVDLA_S_AXI_BID),
		.NVDLA_S_AXI_BRESP(NVDLA_S_AXI_BRESP),
		.NVDLA_S_AXI_BUSER(NVDLA_S_AXI_BUSER),
		.NVDLA_S_AXI_BVALID(NVDLA_S_AXI_BVALID),
		.NVDLA_S_AXI_BREADY(NVDLA_S_AXI_BREADY),
		.NVDLA_S_AXI_ARID(NVDLA_S_AXI_ARID),
		.NVDLA_S_AXI_ARADDR(NVDLA_S_AXI_ARADDR),
		.NVDLA_S_AXI_ARLEN(NVDLA_S_AXI_ARLEN),
		.NVDLA_S_AXI_ARSIZE(NVDLA_S_AXI_ARSIZE),
		.NVDLA_S_AXI_ARBURST(NVDLA_S_AXI_ARBURST),
		.NVDLA_S_AXI_ARLOCK(NVDLA_S_AXI_ARLOCK),
		.NVDLA_S_AXI_ARCACHE(NVDLA_S_AXI_ARCACHE),
		.NVDLA_S_AXI_ARPROT(NVDLA_S_AXI_ARPROT),
		.NVDLA_S_AXI_ARQOS(NVDLA_S_AXI_ARQOS),
		.NVDLA_S_AXI_ARREGION(NVDLA_S_AXI_ARREGION),
		.NVDLA_S_AXI_ARUSER(NVDLA_S_AXI_ARUSER),
		.NVDLA_S_AXI_ARVALID(NVDLA_S_AXI_ARVALID),
		.NVDLA_S_AXI_ARREADY(NVDLA_S_AXI_ARREADY),
		.NVDLA_S_AXI_RID(NVDLA_S_AXI_RID),
		.NVDLA_S_AXI_RDATA(NVDLA_S_AXI_RDATA),
		.NVDLA_S_AXI_RRESP(NVDLA_S_AXI_RRESP),
		.NVDLA_S_AXI_RLAST(NVDLA_S_AXI_RLAST),
		.NVDLA_S_AXI_RUSER(NVDLA_S_AXI_RUSER),
		.NVDLA_S_AXI_RVALID(NVDLA_S_AXI_RVALID),
		.NVDLA_S_AXI_RREADY(NVDLA_S_AXI_RREADY),
		.NVDLA2CORE_INTERRUPT(NVDLA2CORE_INTERRUPT),
		.clk(clk),
		.rst_n(rst_n),
		.NVDLA_M_AXI_ACLK(NVDLA_M_AXI_ACLK),
		.NVDLA_M_AXI_AWID(NVDLA_M_AXI_AWID),
		.NVDLA_M_AXI_AWADDR(NVDLA_M_AXI_AWADDR),
		.NVDLA_M_AXI_AWLEN(NVDLA_M_AXI_AWLEN),
		.NVDLA_M_AXI_AWSIZE(NVDLA_M_AXI_AWSIZE),
		.NVDLA_M_AXI_AWBURST(NVDLA_M_AXI_AWBURST),
		.NVDLA_M_AXI_AWLOCK(NVDLA_M_AXI_AWLOCK),
		.NVDLA_M_AXI_AWCACHE(NVDLA_M_AXI_AWCACHE),
		.NVDLA_M_AXI_AWPROT(NVDLA_M_AXI_AWPROT),
		.NVDLA_M_AXI_AWQOS(NVDLA_M_AXI_AWQOS),
		.NVDLA_M_AXI_AWUSER(NVDLA_M_AXI_AWUSER),
		.NVDLA_M_AXI_AWVALID(NVDLA_M_AXI_AWVALID),
		.NVDLA_M_AXI_AWREADY(NVDLA_M_AXI_AWREADY),
		.NVDLA_M_AXI_WDATA(NVDLA_M_AXI_WDATA),
		.NVDLA_M_AXI_WSTRB(NVDLA_M_AXI_WSTRB),
		.NVDLA_M_AXI_WLAST(NVDLA_M_AXI_WLAST),
		.NVDLA_M_AXI_WUSER(NVDLA_M_AXI_WUSER),
		.NVDLA_M_AXI_WVALID(NVDLA_M_AXI_WVALID),
		.NVDLA_M_AXI_WREADY(NVDLA_M_AXI_WREADY),
		.NVDLA_M_AXI_BID(NVDLA_M_AXI_BID),
		.NVDLA_M_AXI_BRESP(NVDLA_M_AXI_BRESP),
		.NVDLA_M_AXI_BUSER(NVDLA_M_AXI_BUSER),
		.NVDLA_M_AXI_BVALID(NVDLA_M_AXI_BVALID),
		.NVDLA_M_AXI_BREADY(NVDLA_M_AXI_BREADY),
		.NVDLA_M_AXI_ARID(NVDLA_M_AXI_ARID),
		.NVDLA_M_AXI_ARADDR(NVDLA_M_AXI_ARADDR),
		.NVDLA_M_AXI_ARLEN(NVDLA_M_AXI_ARLEN),
		.NVDLA_M_AXI_ARSIZE(NVDLA_M_AXI_ARSIZE),
		.NVDLA_M_AXI_ARBURST(NVDLA_M_AXI_ARBURST),
		.NVDLA_M_AXI_ARLOCK(NVDLA_M_AXI_ARLOCK),
		.NVDLA_M_AXI_ARCACHE(NVDLA_M_AXI_ARCACHE),
		.NVDLA_M_AXI_ARPROT(NVDLA_M_AXI_ARPROT),
		.NVDLA_M_AXI_ARQOS(NVDLA_M_AXI_ARQOS),
		.NVDLA_M_AXI_ARUSER(NVDLA_M_AXI_ARUSER),
		.NVDLA_M_AXI_ARVALID(NVDLA_M_AXI_ARVALID),
		.NVDLA_M_AXI_ARREADY(NVDLA_M_AXI_ARREADY),
		.NVDLA_M_AXI_RID(NVDLA_M_AXI_RID),
		.NVDLA_M_AXI_RDATA(NVDLA_M_AXI_RDATA),
		.NVDLA_M_AXI_RRESP(NVDLA_M_AXI_RRESP),
		.NVDLA_M_AXI_RLAST(NVDLA_M_AXI_RLAST),
		.NVDLA_M_AXI_RUSER(NVDLA_M_AXI_RUSER),
		.NVDLA_M_AXI_RVALID(NVDLA_M_AXI_RVALID),
		.NVDLA_M_AXI_RREADY(NVDLA_M_AXI_RREADY)
	);
	RAM_CONTROL RAM0(
		.RAM_S_AXI_ACLK(clk),
		.RAM_S_AXI_ARESETN(rst_n),
		.RAM_S_AXI_AWID(RAM_S_AXI_AWID),
		.RAM_S_AXI_AWADDR(RAM_S_AXI_AWADDR),
		.RAM_S_AXI_AWLEN(RAM_S_AXI_AWLEN),
		.RAM_S_AXI_AWSIZE(RAM_S_AXI_AWSIZE),
		.RAM_S_AXI_AWBURST(RAM_S_AXI_AWBURST),
		.RAM_S_AXI_AWLOCK(RAM_S_AXI_AWLOCK),
		.RAM_S_AXI_AWCACHE(RAM_S_AXI_AWCACHE),
		.RAM_S_AXI_AWPROT(RAM_S_AXI_AWPROT),
		.RAM_S_AXI_AWQOS(RAM_S_AXI_AWQOS),
		.RAM_S_AXI_AWREGION(RAM_S_AXI_AWREGION),
		.RAM_S_AXI_AWUSER(RAM_S_AXI_AWUSER),
		.RAM_S_AXI_AWVALID(RAM_S_AXI_AWVALID),
		.RAM_S_AXI_AWREADY(RAM_S_AXI_AWREADY),
		.RAM_S_AXI_WDATA(RAM_S_AXI_WDATA),
		.RAM_S_AXI_WSTRB(RAM_S_AXI_WSTRB),
		.RAM_S_AXI_WLAST(RAM_S_AXI_WLAST),
		.RAM_S_AXI_WUSER(RAM_S_AXI_WUSER),
		.RAM_S_AXI_WVALID(RAM_S_AXI_WVALID),
		.RAM_S_AXI_WREADY(RAM_S_AXI_WREADY),
		.RAM_S_AXI_BID(RAM_S_AXI_BID),
		.RAM_S_AXI_BRESP(RAM_S_AXI_BRESP),
		.RAM_S_AXI_BUSER(RAM_S_AXI_BUSER),
		.RAM_S_AXI_BVALID(RAM_S_AXI_BVALID),
		.RAM_S_AXI_BREADY(RAM_S_AXI_BREADY),
		.RAM_S_AXI_ARID(RAM_S_AXI_ARID),
		.RAM_S_AXI_ARADDR(RAM_S_AXI_ARADDR),
		.RAM_S_AXI_ARLEN(RAM_S_AXI_ARLEN),
		.RAM_S_AXI_ARSIZE(RAM_S_AXI_ARSIZE),
		.RAM_S_AXI_ARBURST(RAM_S_AXI_ARBURST),
		.RAM_S_AXI_ARLOCK(RAM_S_AXI_ARLOCK),
		.RAM_S_AXI_ARCACHE(RAM_S_AXI_ARCACHE),
		.RAM_S_AXI_ARPROT(RAM_S_AXI_ARPROT),
		.RAM_S_AXI_ARQOS(RAM_S_AXI_ARQOS),
		.RAM_S_AXI_ARREGION(RAM_S_AXI_ARREGION),
		.RAM_S_AXI_ARUSER(RAM_S_AXI_ARUSER),
		.RAM_S_AXI_ARVALID(RAM_S_AXI_ARVALID),
		.RAM_S_AXI_ARREADY(RAM_S_AXI_ARREADY),
		.RAM_S_AXI_RID(RAM_S_AXI_RID),
		.RAM_S_AXI_RDATA(RAM_S_AXI_RDATA),
		.RAM_S_AXI_RRESP(RAM_S_AXI_RRESP),
		.RAM_S_AXI_RLAST(RAM_S_AXI_RLAST),
		.RAM_S_AXI_RUSER(RAM_S_AXI_RUSER),
		.RAM_S_AXI_RVALID(RAM_S_AXI_RVALID),
		.RAM_S_AXI_RREADY(RAM_S_AXI_RREADY)
	);
	CPU_CONTROL CPU0(
		.CPU_M_AXI_ACLK(clk),
		.rst_n(rst_n),
		.CPU_AWID(CPU_AWID),
		.CPU_AWADDR(CPU_AWADDR),
		.CPU_AWLEN(CPU_AWLEN),
		.CPU_AWSIZE(CPU_AWSIZE),
		.CPU_AWBURST(CPU_AWBURST),
		.CPU_AWLOCK(CPU_AWLOCK),
		.CPU_AWCACHE(CPU_AWCACHE),
		.CPU_AWPROT(CPU_AWPROT),
		.CPU_AWQOS(CPU_AWQOS),
		.CPU_AWUSER(CPU_AWUSER),
		.CPU_AWVALID(CPU_AWVALID),
		.CPU_AWREADY(CPU_AWREADY),
		.CPU_WDATA(CPU_WDATA),
		.CPU_WSTRB(CPU_WSTRB),
		.CPU_WLAST(CPU_WLAST),
		.CPU_WUSER(CPU_WUSER),
		.CPU_WVALID(CPU_WVALID),
		.CPU_WREADY(CPU_WREADY),
		.CPU_BID(CPU_BID),
		.CPU_BRESP(CPU_BRESP),
		.CPU_BUSER(CPU_BUSER),
		.CPU_BVALID(CPU_BVALID),
		.CPU_BREADY(CPU_BREADY),
		.CPU_ARID(CPU_ARID),
		.CPU_ARADDR(CPU_ARADDR),
		.CPU_ARLEN(CPU_ARLEN),
		.CPU_ARSIZE(CPU_ARSIZE),
		.CPU_ARBURST(CPU_ARBURST),
		.CPU_ARLOCK(CPU_ARLOCK),
		.CPU_ARCACHE(CPU_ARCACHE),
		.CPU_ARPROT(CPU_ARPROT),
		.CPU_ARQOS(CPU_ARQOS),
		.CPU_ARUSER(CPU_ARUSER),
		.CPU_ARVALID(CPU_ARVALID),
		.CPU_ARREADY(CPU_ARREADY),
		.CPU_RID(CPU_RID),
		.CPU_RDATA(CPU_RDATA),
		.CPU_RRESP(CPU_RRESP),
		.CPU_RLAST(CPU_RLAST),
		.CPU_RUSER(CPU_RUSER),
		.CPU_RVALID(CPU_RVALID),
		.CPU_RREADY(CPU_RREADY)
	);
endmodule
