#include "othello_comm.h"
#include "base_env.h"

#include <cstdlib>
#include <cstring>
#include <stack>
#include <string>
#include <unordered_set>
#include <vector>

#if defined(_WIN32) || defined(_WIN64)
#  include <intrin.h>
#  define __builtin_popcount __popcnt
#  define __builtin_popcountll __popcnt64
#endif


struct OthelloStone {
    OthelloCoordId self_id;      // Id of this stone
    OthelloCoordId next_id;      // Use like link-list
    OthelloCoordId parent_id;    // Use like union-find-set (rooted by tail)

    // inline void SetSelfId(OthelloCoordId id) { self_id = id; }

    inline void Reset(OthelloCoordId id = OthelloComm::COORD_UNSET) {
        next_id = parent_id = self_id;
    }
} ;


class OthelloEnv: public BaseEnv {
public:
	OthelloEnv();
    // OthelloEnv(const OthelloEnv &ge);
    ~OthelloEnv();
    int Move(int action) override;
    bool IsFinish() override { return ((state_ != 0 ? true : false) || is_resign_); }
    void GetResult(float& res) override;
    void GetFeature(BaseFeature& feature) override;
    int GetActionNum() override;
    void GetInputDim(vector<int>& input_dim) override;
    void GetLegalAction(vector<int>& action) override;
    bool IsLegal(int action) override { return OthelloFunction::IsResign(action) || OthelloFunction::IsPass(action) || legal_move_map_[action]; }
    std::string action2str(int action) override { return OthelloFunction::IdToStr(const OthelloCoordId action); }
    int CurrentPlayer() override { return current_player_; }

    // void TransformFeatures(BaseFeature& feature, int transform_mode);
    // void TransformPolicy(int transform_mode); // this is reverse mode of TransformFeature

protected:
    // void Init();

    // void CopyFrom(const OthelloEnv &src);
    int CalcResult() const;
    OthelloStoneColor GetWinner() const;
    inline void HandOff() { current_player_ = Opponent(); }
    inline OthelloStoneColor Opponent(const OthelloStoneColor color = OthelloComm::COLOR_UNKNOWN) const {
        return OthelloComm::BLACK + OthelloComm::WHITE
            - (OthelloComm::COLOR_UNKNOWN != color ? color : current_player_);
    }
    inline OthelloStoneColor Self() const { return current_player_; }
    inline OthelloCoordId GetLastMove() const { return last_position_; }
    // inline OthelloStoneColor CurrentPlayer() const { return current_player_; }
    //void OthelloEnv::TransformCoord(OthelloCoordId &x, OthelloCoordId &y, int mode, bool reverse = false)

    void GetSensibleMove();
    bool  Check_Cross(OthelloCoordId x, OthelloCoordId y, int update) const; 
    int  Check_Straight_Army(OthelloCoordId x, OthelloCoordId y, int d, int update) const;
    int  Find_Legal_Moves(int color) const;

protected:
    // board utils
    OthelloStone stones_[OthelloComm::OTHELLOBOARD_SIZE];
    OthelloStoneColor board_state_[OthelloComm::OTHELLOBOARD_SIZE];
    OthelloStoneColor current_player_;
    OthelloCoordId last_position_;
    bool is_resign_;
    int state_;
    int B_;
    int W_;

    // hash board state
    std::unordered_set<uint64_t> board_hash_states_;
    uint64_t zobrist_hash_value_;

    // features
    bool legal_move_map_[OthelloComm::OTHELLOBOARD_SIZE];
    OthelloSize move_count_[OthelloComm::OTHELLOBOARD_SIZE];

    std::vector<std::string> feature_history_list_;
};
