#include "connect4_comm.h"
#include "base_env.h"

#include <cstdlib>
#include <cstring>
#include <stack>
#include <string>
#include <unordered_set>
#include <vector>

#if defined(_WIN32) || defined(_WIN64)
#  include <intrin.h>
#  define __builtin_popcount __popcnt
#  define __builtin_popcountll __popcnt64
#endif


struct Connect4Stone {
    Connect4CoordId self_id;      // Id of this stone
    Connect4CoordId next_id;      // Use like link-list
    Connect4CoordId parent_id;    // Use like union-find-set (rooted by tail)

    // inline void SetSelfId(Connect4CoordId id) { self_id = id; }

    inline void Reset(Connect4CoordId id = Connect4Comm::COORD_UNSET) {
        next_id = parent_id = self_id;
    }
} ;


class Connect4Env: public BaseEnv {
public:
	Connect4Env();
    // Connect4Env(const Connect4Env &ge);
    ~Connect4Env();
    int Move(int action) override;
    bool IsFinish() override { return ((state_ != 0 ? true : false) || is_resign_); }
    void GetResult(float& res) override;
    void GetFeature(BaseFeature& feature) override;
    int GetActionNum() override;
    void GetInputDim(vector<int>& input_dim) override;
    void GetLegalAction(vector<int>& action) override;
    bool IsLegal(int action) override { return Connect4Function::IsResign(action) || legal_move_map_[action]; }
    std::string action2str(int action) override { return Connect4Function::IdToStr(const Connect4CoordId action); }
    int CurrentPlayer() override { return current_player_; }

    // void TransformFeatures(BaseFeature& feature, int transform_mode);
    // void TransformPolicy(int transform_mode); // this is reverse mode of TransformFeature

protected:
    // void Init();

    // void CopyFrom(const Connect4Env &src);
    int Connect4Result(Connect4CoordId x, Connect4CoordId y) const;
    int CalcResult() const;
    Connect4StoneColor GetWinner() const;
    inline void HandOff() { current_player_ = Opponent(); }
    inline Connect4StoneColor Opponent(const Connect4StoneColor color = Connect4Comm::COLOR_UNKNOWN) const {
        return Connect4Comm::BLACK + Connect4Comm::WHITE
            - (Connect4Comm::COLOR_UNKNOWN != color ? color : current_player_);
    }
    inline Connect4StoneColor Self() const { return current_player_; }
    inline Connect4CoordId GetLastMove() const { return last_position_; }
    // inline Connect4StoneColor CurrentPlayer() const { return current_player_; }
    //void Connect4Env::TransformCoord(Connect4CoordId &x, Connect4CoordId &y, int mode, bool reverse = false)

    void GetSensibleMove();
    void Find_Legal_Moves() const{
    int dir_x() const;
    int dir_y() const;

protected:
    // board utils
    Connect4Stone stones_[Connect4Comm::CONNECT4BOARD_SIZE];
    Connect4StoneColor board_state_[Connect4Comm::CONNECT4BOARD_SIZE];
    Connect4StoneColor current_player_;
    Connect4CoordId last_position_;
    bool is_resign_;
    int state_;
    int action_count_;

    // hash board state
    std::unordered_set<uint64_t> board_hash_states_;
    uint64_t zobrist_hash_value_;

    // features
    bool legal_move_map_[Connect4Comm::CONNECT4BOARD_SIZE];
    Connect4Size move_count_[Connect4Comm::CONNECT4BOARD_SIZE];

    std::vector<std::string> feature_history_list_;
};
