#include "chinesechess_comm.h"
#include "base_env.h"

#include <cstdlib>
#include <cstring>
#include <stack>
#include <string>
#include <unordered_set>
#include <vector>

#if defined(_WIN32) || defined(_WIN64)
#  include <intrin.h>
#  define __builtin_popcount __popcnt
#  define __builtin_popcountll __popcnt64
#endif

typedef vector<bool> BaseFeature;

 
struct ChineseChessStone {
    ChineseChessCoordId self_id;      // Id of this stone
    ChineseChessCoordId next_id;      // Use like link-list
    ChineseChessCoordId parent_id;    // Use like union-find-set (rooted by tail)

    // inline void SetSelfId(ChineseChessCoordId id) { self_id = id; }

    inline void Reset(ChineseChessCoordId id = ChineseChessComm::COORD_UNSET) {
        next_id = parent_id = self_id;
    }
} ;


class ChineseChessEnv: public BaseEnv {
public:
	ChineseChessEnv();
    // ChineseChessEnv(const ChineseChessEnv &ge);
    ~ChineseChessEnv();

    int Move(int action) override;
    bool IsFinish() override { return ((state_ != 0 ? true : false) || is_resign_); }
    void GetResult(float& res) override;
    void GetFeature(BaseFeature& feature) override;
    int GetActionNum() override;
    void GetInputDim(vector<int>& input_dim) override;
    void GetLegalAction(vector<int>& action) override;
    bool IsLegal(int action) override { return ChineseChessFunction::IsResign(action) || IsMoveValid(action); }
    std::string action2str(int action) override;
    int CurrentPlayer() override { return current_player_; }

protected:
    // void Init();

    // void CopyFrom(const ChineseChessEnv &src);
    int CalcResult() const;
    ChineseChessStoneColor GetWinner() const;
    inline void HandOff() { current_player_ = Opponent(); }
    inline ChineseChessStoneColor Opponent(const ChineseChessStoneColor color = ChineseChessComm::COLOR_UNKNOWN) const {
        return ChineseChessComm::RED + ChineseChessComm::BLACK
            - (ChineseChessComm::COLOR_UNKNOWN != color ? color : current_player_);
    }
    inline ChineseChessStoneColor Self() const { return current_player_; }
    inline ChineseChessCoordId GetLastMove() const { return last_action_; }
    // inline ChineseChessStoneColor CurrentPlayer() const { return current_player_; }
    //void ChineseChessEnv::TransformCoord(ChineseChessCoordId &x, ChineseChessCoordId &y, int mode, bool reverse = false)

    void GetSensibleMove();
    bool IsKingInCheck() const;
    void Find_Legal_Moves() const;
    bool IsMoveValid(int& action) const;

protected:
    // board utils
    std::vector<std::int> action_list_;
    ChineseChessStone stones_[ChineseChessComm::CHINESECHESSBOARD_SIZE];
    ChineseChessStoneColor board_state_[ChineseChessComm::CHINESECHESSBOARD_SIZE];
    ChineseChessStoneColor current_player_;
    int last_action_;
    bool is_resign_;
    int state_;
    bool is_redking_incheck_;
    bool is_blackking_incheck_;

    // hash board state
    std::unordered_set<uint64_t> board_hash_states_;
    uint64_t zobrist_hash_value_;

    // features
    ChineseChessSize move_count_[162000];

    std::vector<std::string> feature_history_list_;
};
