#include "chinesechess_env.h"
 
#include <algorithm>
#include <cmath>

using namespace std;
using namespace ChineseChessComm;
using namespace ChineseChessFunction;
using namespace ChineseChessFeature;

ChineseChessEnv::ChineseChessEnv() {
    CreateGlobalVariables();

    FOR_EACHCOORD(i) {
        stones_[i].self_id = i;
    }

    action_list_.clear();
    feature_history_list_.clear();
    memset(board_state_, 0, sizeof(board_state_));
    memset(move_count_, 0, sizeof(move_count_));
    current_player_ = RED;
    last_action_ = COORD_UNSET;
    is_resign_ = false;
    is_redking_incheck_ = false;
    is_blackking_incheck_ = false;
    state_ = 0;
    board_hash_states_.clear();
    zobrist_hash_value_ = 0;
}

//ChineseChessEnv::ChineseChessEnv(const ChineseChessEnv &ge) : ChineseChessEnv() {
//     CopyFrom(ge);
// }
 
ChineseChessEnv::~ChineseChessEnv() {

}

 // void ChineseChessEnv::CopyFrom(const ChineseChessEnv &src) {
 //     *this = src;
 // }


void ChineseChessEnv::GetSensibleMove() {
    // Add new feature plane
    string plane;
    // red
    {
        plane = "";
        FOR_EACHCOORD(id) {
            if (board_state_[id] == RED) {
                plane += "1";
            } else {
                plane += "0";
            }
        }
        feature_history_list_.push_back(plane);
    }
    // black
    {
        plane = "";
        FOR_EACHCOORD(id) {
            if (board_state_[id] == BLACK) {
                plane += "1";
            } else {
                plane += "0";
            }
        }
        feature_history_list_.push_back(plane);
    }

    Find_Legal_Moves();
}
 
int ChineseChessState::Move(int action) {
    ChineseChessCoordId from_id, to_id;
    ChineseChessStoneColor piece;
    Find_Legal_Moves();
    if (!IsLegal(action)) {
        return -1;
    }
    if(IsResign(action)){
      is_resign_ = true;
      return 0;
    }

    last_action_ = action;

    {
        zobrist_hash_value_ ^= g_zobrist_player_hash_weight[Self()];
        zobrist_hash_value_ ^= g_zobrist_player_hash_weight[Opponent()];
        zobrist_hash_value_ ^= g_zobrist_board_hash_weight[Self()][action];
    }
    ChineseChessFunction::ActionToId(action, piece, from_id, to_id);

    ++move_count_[action];
    board_state_[to_id] = board_state_[from_id];
    board_state_[from_id] = ChineseChessComm::EMPTY;

    HandOff();
    GetSensibleMove();


    return 0;
}


void ChineseChessEnv::Find_Legal_Moves() const{    
    action_list_.clear();
    is_redking_incheck_ = is_blackking_incheck_ = false;
    int action;
    ChineseChessCoordId i, j, k, l;
    ChineseChessCoordId i_x, i_y, j_x, j_y , k_x, k_y, l_x, l_y;
    bool is_king_facetoface = false, is_mystone = false, is_chariotpass = false, is_horsepass = false;
    int face_tag = 0;
    for(i = 0; i < ChineseChessComm::CHINESECHESSBOARD_SIZE; ++i){  //i:from_id
        ChineseChessStoneColor piece = board_state_[i];
        for(j = 0; j < ChineseChessComm::CHINESECHESSBOARD_SIZE; j++){    //j:to_id
            if(((board_state_[j] == ChineseChessComm::RED_PAWN || board_state_[j] == ChineseChessComm::RED_CANNON || board_state_[j] == ChineseChessComm::RED_HORSE || board_state_[j] == ChineseChessComm::RED_CHARIOT ||
               board_state_[j] == ChineseChessComm::RED_ELEPHANT || board_state_[j] == ChineseChessComm::RED_ADVISER || board_state_[j] == ChineseChessComm::RED_KING) && current_player_ == ChineseChessComm::RED) ||
               ((board_state_[j] == ChineseChessComm::BLACK_PAWN || board_state_[j] == ChineseChessComm::BLACK_CANNON || board_state_[j] == ChineseChessComm::BLACK_HORSE || board_state_[j] == ChineseChessComm::BLACK_CHARIOT ||
               board_state_[j] == ChineseChessComm::BLACK_ELEPHANT || board_state_[j] == ChineseChessComm::BLACK_ADVISER || board_state_[j] == ChineseChessComm::BLACK_KING) && current_player_ == ChineseChessComm::BLACK)){
                is_mystone = true;
            }
            bool color = (current_player_ ==  ChineseChessComm::RED) ? true : false;
            switch (piece){
                case ChineseChessComm::RED_KING : case ChineseChessComm::BLACK_KING : // King
                    {
                        for(k = 0; k < ChineseChessComm::CHINESECHESSBOARD_SIZE; k++){  //k:another_king_id
                            if(piece == ChineseChessComm::RED_KING){
                                if(board_state_[k] == ChineseChessComm::BLACK_KING){
                                    break;
                                }
                            }else{
                                if(board_state_[k] == ChineseChessComm::RED_KING){
                                    break;
                                }
                            }
                        }
                        i_x = i_y = j_x = j_y = k_x = k_y = l_x = l_y = ChineseChessComm::COORD_UNSET;
                        ChineseChessFunction::IdToCoord(i, i_x, i_y);
                        ChineseChessFunction::IdToCoord(j, j_x, j_y);
                        if(k != ChineseChessComm::CHINESECHESSBOARD_SIZE){
                            ChineseChessFunction::IdToCoord(k, k_x, k_y);
                        }
                        if ((color ? 7 : 0) <= j_x && j_x <= (color ? 9 : 2) && j_y >= 3 && j_y <= 5 &&    
                            ((abs((i_x - j_x)) == 1 && abs((i_y - j_y)) == 0) || (abs((i_y - j_y)) == 1 && abs((i_x - j_x)) == 0))) {    
                            if (i_x == j_x && (j_y == k_y)){
                                face_tag = 0;
                                l_y = j_y;
                                for (int l_x = (i_x > k_x ? k_x : i_x) + 1; l_x < (i_x > k_x ? i_x : k_x); l_x++){
                                    ChineseChessFunction::CoordToId(l_x, l_y, l);
                                    if (board_state_[l] != ChineseChessComm::EMPTY){
                                        face_tag = 1;
                                    }
                                } 
                                if(face_tag == 0){
                                    is_king_facetoface = true;
                                }
                            }       
                            if(!is_mystone && !is_king_facetoface){
                                if(piece == ChineseChessComm::RED_KING && current_player_ == ChineseChessComm::RED){
                                    ChineseChessFunction::IdToAction(piece, i, j, action);
                                    action_list_.push_back(action);            
                                }
                                if(piece == ChineseChessComm::BLACK_KING && current_player_ == ChineseChessComm::BLACK){
                                    ChineseChessFunction::IdToAction(piece, i, j, action);
                                    action_list_.push_back(action);            
                                }        
                            }                                                   
                        }                                                                                                  
                    }
                    break;

                case ChineseChessComm::RED_CHARIOT : case ChineseChessComm::BLACK_CHARIOT : // Chariot
                    {
                        i_x = i_y = j_x = j_y = k_x = k_y = l_x = l_y = ChineseChessComm::COORD_UNSET;
                        ChineseChessFunction::IdToCoord(i, i_x, i_y);
                        ChineseChessFunction::IdToCoord(j, j_x, j_y);
                        if ((i_x == j_x)  && (i_y - j_y) != 0){      //横向前進
                            for (l_y = (i_y > j_y ? j_y : i_y) + 1; l_y < (i_y > j_y ? i_y : j_y); l_y++){
                                l_x = j_x;
                                ChineseChessFunction::CoordToId(l_x, l_y, l);
                                if (board_state_[l] != ChineseChessComm::EMPTY){
                                    is_chariotpass = true;
                                }
                            }
                        }else if ((i_x - j_x) != 0 && (i_y == j_y)){  //纵向前進
                            for (l_x = (i_x > j_x ? j_x : i_x) + 1; l_x < (i_x > j_x ? i_x : j_x); l_x++){
                                l_y = j_y;
                                ChineseChessFunction::CoordToId(l_x, l_y, l);
                                if (board_state_[l] != ChineseChessComm::EMPTY){
                                    is_chariotpass = true;
                                }
                            }
                        }
                        if(!is_chariotpass && !is_mystone){
                            if(piece == ChineseChessComm::RED_CHARIOT && current_player_ == ChineseChessComm::RED){
                                ChineseChessFunction::IdToAction(piece, i, j, action);
                                action_list_.push_back(action);        
                            }
                            if(piece == ChineseChessComm::BLACK_CHARIOT && current_player_ == ChineseChessComm::BLACK){
                                ChineseChessFunction::IdToAction(piece, i, j, action);
                                action_list_.push_back(action);        
                            }
                            if(piece == ChineseChessComm::RED_CHARIOT && board_state_[j] == ChineseChessComm::BLACK_KING){
                                is_blackking_incheck_ = true;
                            }
                            if(piece == ChineseChessComm::BLACK_CHARIOT && board_state_[j] == ChineseChessComm::RED_KING){
                                is_redking_incheck_ = true;
                            }
                        }
                    }
                    break;

                case ChineseChessComm::RED_HORSE : case ChineseChessComm::BLACK_HORSE : // Horse
                    {
                        i_x = i_y = j_x = j_y = k_x = k_y = l_x = l_y = ChineseChessComm::COORD_UNSET;
                        ChineseChessFunction::IdToCoord(i, i_x, i_y);
                        ChineseChessFunction::IdToCoord(j, j_x, j_y);
                        if (abs(i_y - j_y) == 2) {//拐馬腳Y,横向
                            l_x = i_x;
                            l_y = i_y - (i_y - j_y)/2;
                            ChineseChessFunction::CoordToId(l_x, l_y, l);
                            if (board_state_[l] != ChineseChessComm::EMPTY){
                                is_horsepass = true;
                            }
                        }
                        if (abs(i_x - j_x) == 2) {//拐馬腳X,纵向
                            l_y = i_y;
                            l_x = i_x - (i_x - j_x)/2;
                            ChineseChessFunction::CoordToId(l_x, l_y, l);
                            if (board_state_[l] != ChineseChessComm::EMPTY){
                                is_horsepass = true;
                            }
                        }
                        if (abs(i_y - j_y) == 2 && abs(i_x - j_x) == 1 || (abs(i_y - j_y) == 1 && abs(i_x - j_x) == 2)) {
                            if(!is_mystone && !is_horsepass){
                                if(piece == ChineseChessComm::RED_HORSE && current_player_ == ChineseChessComm::RED){
                                    ChineseChessFunction::IdToAction(piece, i, j, action);
                                    action_list_.push_back(action);   
                                }
                                if(piece == ChineseChessComm::BLACK_HORSE && current_player_ == ChineseChessComm::BLACK){
                                    ChineseChessFunction::IdToAction(piece, i, j, action);
                                    action_list_.push_back(action);   
                                }
                                if(piece == ChineseChessComm::RED_HORSE && board_state_[j] == ChineseChessComm::BLACK_KING){
                                    is_blackking_incheck_ = true;
                                }
                                if(piece == ChineseChessComm::BLACK_HORSE && board_state_[j] == ChineseChessComm::RED_KING){
                                    is_redking_incheck_ = true;
                                }
                            }
                        }
                    }
                    break;

                case ChineseChessComm::RED_CANNON : case ChineseChessComm::BLACK_CANNON : // Cannon
                    {
                        i_x = i_y = j_x = j_y = k_x = k_y = l_x = l_y = ChineseChessComm::COORD_UNSET;
                        ChineseChessFunction::IdToCoord(i, i_x, i_y);
                        ChineseChessFunction::IdToCoord(j, j_x, j_y);
                        int count = 0;
                        if (abs(i_x - j_x) != 0 && abs(i_y - j_y) == 0){ //纵向
                            if (i_x - j_x > 0){
                                for (l_x = i_x - 1; l_x > j_x; l_x--){
                                    l_y = i_y;
                                    ChineseChessFunction::CoordToId(l_x, l_y, l);
                                    if (board_state_[l] != ChineseChessComm::EMPTY){
                                        count++;
                                    }
                                }
                                if ((count == 1 && (board_state_[j] != ChineseChessComm::EMPTY && !is_mystone)) || (count == 0 && board_state_[j] == ChineseChessComm::EMPTY)){
                                    if(piece == ChineseChessComm::RED_CANNON && current_player_ == ChineseChessComm::RED){
                                        ChineseChessFunction::IdToAction(piece, i, j, action);
                                        action_list_.push_back(action);
                                    }   
                                    if(piece == ChineseChessComm::BLACK_CANNON && current_player_ == ChineseChessComm::BLACK){
                                        ChineseChessFunction::IdToAction(piece, i, j, action);
                                        action_list_.push_back(action);
                                    }   
                                    if(piece == ChineseChessComm::RED_CANNON && board_state_[j] == ChineseChessComm::BLACK_KING){
                                        is_blackking_incheck_ = true;
                                    }
                                    if(piece == ChineseChessComm::BLACK_CANNON && board_state_[j] == ChineseChessComm::RED_KING){
                                        is_redking_incheck_ = true;
                                    }
                                }
                            }else{
                                for (l_x = i_x + 1; l_x < j_x; l_x++){
                                    l_y = i_y;
                                    ChineseChessFunction::CoordToId(l_x, l_y, l);
                                    if (board_state_[l] != ChineseChessComm::EMPTY){
                                        count++;
                                    }
                                }
                                if ((count == 1 && (board_state_[j] != ChineseChessComm::EMPTY && !is_mystone)) || (count == 0 && board_state_[j] == ChineseChessComm::EMPTY)){
                                    if(piece == ChineseChessComm::RED_CANNON && current_player_ == ChineseChessComm::RED){
                                        ChineseChessFunction::IdToAction(piece, i, j, action);
                                        action_list_.push_back(action);
                                    }   
                                    if(piece == ChineseChessComm::BLACK_CANNON && current_player_ == ChineseChessComm::BLACK){
                                        ChineseChessFunction::IdToAction(piece, i, j, action);
                                        action_list_.push_back(action);
                                    }   
                                    if(piece == ChineseChessComm::RED_CANNON && board_state_[j] == ChineseChessComm::BLACK_KING){
                                        is_blackking_incheck_ = true;
                                    }
                                    if(piece == ChineseChessComm::BLACK_CANNON && board_state_[j] == ChineseChessComm::RED_KING){
                                        is_redking_incheck_ = true;
                                    }
                                }
                            }
                        }else if (abs(i_x - j_x) == 0 && abs(i_y - j_y) != 0){ //横向
                            if (i_y - j_y > 0){
                                for (l_y = i_y - 1; l_y > j_y; l_y){
                                    l_x = i_x;
                                    ChineseChessFunction::CoordToId(l_x, l_y, l);
                                    if (board_state_[l] != ChineseChessComm::EMPTY){
                                        count++;
                                    }
                                }
                                if ((count == 1 && (board_state_[j] != ChineseChessComm::EMPTY && !is_mystone)) || (count == 0 && board_state_[j] == ChineseChessComm::EMPTY)){
                                    if(piece == ChineseChessComm::RED_CANNON && current_player_ == ChineseChessComm::RED){
                                        ChineseChessFunction::IdToAction(piece, i, j, action);
                                        action_list_.push_back(action);
                                    }   
                                    if(piece == ChineseChessComm::BLACK_CANNON && current_player_ == ChineseChessComm::BLACK){
                                        ChineseChessFunction::IdToAction(piece, i, j, action);
                                        action_list_.push_back(action);
                                    }   
                                    if(piece == ChineseChessComm::RED_CANNON && board_state_[j] == ChineseChessComm::BLACK_KING){
                                        is_blackking_incheck_ = true;
                                    }
                                    if(piece == ChineseChessComm::BLACK_CANNON && board_state_[j] == ChineseChessComm::RED_KING){
                                        is_redking_incheck_ = true;
                                    }
                                }
                            }else{
                                for (l_y = i_y + 1; l_y < j_y; l_y++){
                                    l_x = i_x;
                                    ChineseChessFunction::CoordToId(l_x, l_y, l);
                                    if (board_state_[l] != ChineseChessComm::EMPTY){
                                        count++;
                                    }
                                }
                                if ((count == 1 && (board_state_[j] != ChineseChessComm::EMPTY && !is_mystone)) || (count == 0 && board_state_[j] == ChineseChessComm::EMPTY)){
                                    if(piece == ChineseChessComm::RED_CANNON && current_player_ == ChineseChessComm::RED){
                                        ChineseChessFunction::IdToAction(piece, i, j, action);
                                        action_list_.push_back(action);
                                    }   
                                    if(piece == ChineseChessComm::BLACK_CANNON && current_player_ == ChineseChessComm::BLACK){
                                        ChineseChessFunction::IdToAction(piece, i, j, action);
                                        action_list_.push_back(action);
                                    }   
                                    if(piece == ChineseChessComm::RED_CANNON && board_state_[j] == ChineseChessComm::BLACK_KING){
                                        is_blackking_incheck_ = true;
                                    }
                                    if(piece == ChineseChessComm::BLACK_CANNON && board_state_[j] == ChineseChessComm::RED_KING){
                                        is_redking_incheck_ = true;
                                    }
                                }
                            }
                        }
                    }
                    break;

                case ChineseChessComm::RED_ELEPHANT : case ChineseChessComm::BLACK_ELEPHANT : // Elephant
                    {
                        i_x = i_y = j_x = j_y = k_x = k_y = l_x = l_y = ChineseChessComm::COORD_UNSET;
                        ChineseChessFunction::IdToCoord(i, i_x, i_y);
                        ChineseChessFunction::IdToCoord(j, j_x, j_y);
                        l_x = (i_x + j_x)/2;
                        l_y = (i_y + j_y)/2;
                        ChineseChessFunction::CoordToId(l_x, l_y, l);
                        if(!is_mystone){
                            if (board_state_[l] == ChineseChessComm::EMPTY){ //中間沒卡到東西
                                if (current_player_ == ChineseChessComm::RED && piece == ChineseChessComm::RED_ELEPHANT){
                                    if (abs(j_x - i_x) == 2 && abs(j_y - i_y) == 2 && j_x >= 5 && j_x <= 9){
                                        ChineseChessFunction::IdToAction(piece, i, j, action);
                                        action_list_.push_back(action);
                                    }
                                }if(current_player_ == ChineseChessComm::BLACK && piece == ChineseChessComm::BLACK_PAWN){
                                    if (abs(j_x - i_x) == 2 && abs(j_y - i_y) == 2 && j_x>= 0 && j_x <= 4){
                                        ChineseChessFunction::IdToAction(piece, i, j, action);
                                        action_list_.push_back(action);
                                    }
                                }
                            }
                        }
                    }
                    break;
                    

                case ChineseChessComm::RED_ADVISER : case ChineseChessComm::BLACK_ADVISER : // Adviser
                    {
                        i_x = i_y = j_x = j_y = k_x = k_y = l_x = l_y = ChineseChessComm::COORD_UNSET;
                        ChineseChessFunction::IdToCoord(i, i_x, i_y);
                        ChineseChessFunction::IdToCoord(j, j_x, j_y);
                        if(!is_mystone){
                            if (j_y >= 3 && j_y <= 5) {
                                if (current_player_ == ChineseChessComm::RED && piece == ChineseChessComm::RED_ADVISER) {
                                    if (abs(j_x - i_x) == 1 && abs(j_y - i_y) == 1 && j_x >= 7 && j_x <= 9){
                                        ChineseChessFunction::IdToAction(piece, i, j, action);
                                        action_list_.push_back(action);
                                    }
                                }
                                if(current_player_ == ChineseChessComm::BLACK && piece == ChineseChessComm::BLACK_ADVISER) {
                                    if (abs(j_x - i_x) == 1 && abs(j_y - i_y) == 1 && j_x >= 0 && j_x <= 2){
                                        ChineseChessFunction::IdToAction(piece, i, j, action);
                                        action_list_.push_back(action);
                                    }
                                }
                            }
                        }
                    }
                    break;

                case ChineseChessComm::RED_PAWN : case ChineseChessComm::BLACK_PAWN : // Pawn
                    {
                        i_x = i_y = j_x = j_y = k_x = k_y = l_x = l_y = ChineseChessComm::COORD_UNSET;
                        ChineseChessFunction::IdToCoord(i, i_x, i_y);
                        ChineseChessFunction::IdToCoord(j, j_x, j_y);
                        if(!is_mystone){
                            if (piece == ChineseChessComm::RED_PAWN) {//red
                                if (i_x <= 4) {//已過河
                                    if ((((i_x - j_x) == 1 && abs(i_y - j_y) == 0) || (abs(i_x - j_x) == 0 && abs(i_y - j_y) == 1))){
                                        if(current_player_ == ChineseChessComm::RED){
                                            ChineseChessFunction::IdToAction(piece, i, j, action);
                                            action_list_.push_back(action);
                                        }
                                        if(board_state_[j] == ChineseChessComm::BLACK_KING){
                                            is_blackking_incheck_ = true;
                                        }
                                    }
                                }else{//未過河
                                    if (i_x - j_x == 1 && abs(i_y - j_y) == 0) {
                                        if(current_player_ == ChineseChessComm::RED){
                                            ChineseChessFunction::IdToAction(piece, i, j, action);
                                            action_list_.push_back(action);
                                        }
                                    }
                                }
                            }
                            if(piece == ChineseChessComm::BLACK_PAWN){//black
                                if (i_x >= 5) {//已過河
                                    if ((i_x - j_x == -1 && abs(i_y - j_y) == 0) || (abs(i_x - j_x) == 0 && abs(i_y - j_y) == 1)){
                                        if(current_player_ == ChineseChessComm::BLACK){
                                            ChineseChessFunction::IdToAction(piece, i, j, action);
                                            action_list_.push_back(action);
                                        }
                                        if(board_state_[j] == ChineseChessComm::RED_KING){
                                            is_redking_incheck_ = true;
                                        }
                                    }
                                }else{//未過河
                                    if (i_x - j_x == -1 && abs(i_y - j_y) == 0) {
                                        if(current_player_ == ChineseChessComm::BLACK){
                                            ChineseChessFunction::IdToAction(piece, i, j, action);
                                            action_list_.push_back(action);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    break;

                default : // Invalid, wrong color, or empty
                    continue;
            }
        }
    }

   
}

bool ChineseChessEnv::IsKingInCheck() const{
    if(is_redking_incheck_ && current_player_ == ChineseChessComm::RED){
        return true;
    }
    if(is_blackking_incheck_ && current_player_ == ChineseChessComm::BLACK){
        return true;
    }
    return false;
} // end of IsKingInCheck

bool ChineseChessEnv::IsMoveValid(int &action) const{
    ChineseChessCoordId from_id, to_id;
    ChineseChessStoneColor piece;
    for (unsigned int i = 0; i < action_list_.size(); ++i){
        if (action_list_[i] == action){
            return true;
        }
    }
    return false;
}



int ChineseChessEnv::CalcResult() const {
    ChineseChessStoneColor king;
    ChineseChessCoordId kingid = ChineseChessComm::COORD_UNSET;

    if (current_player_ == ChineseChessComm::RED){
        king = ChineseChessComm::RED_KING;
    }
    else if(current_player_ == ChineseChessComm::BLACK){
        king = ChineseChessComm::BLACK_KING;
    }

    FOR_EACHCOORD(id){
        if(board_state_[id] == king){
            kingid = id;
            break;
        }
    }
   
    if(kingid == ChineseChessComm::COORD_UNSET){
        if(current_player_ == ChineseChessComm::RED){
            state_ = 2;//BLACK WIN!
        }else if (current_player_ == ChineseChessComm::BLACK){
            state_ = 1;//RED WIN!
        }
    }

    return state_;
}


ChineseChessStoneColor ChineseChessEnv::GetWinner() const {
    int result = CalcResult();
    if (result == 3){
      return ChineseChessComm::EMPTY;
    }else if (result == 1){
      return ChineseChessComm::RED;
    }else if(result == 2){
      return ChineseChessComm::BLACK;
    }
}

void ChineseChessEnv::GetResult(float& res) {
	if (GetWinner() == ChineseChessComm::EMPTY){
		res = 0.0f;
	}else{
        res = GetWinner() == CurrentPlayer() ? -1.0f : 1.0f;
    }
}

vector<bool> ChineseChessEnv::GetFeature(BaseFeature& feature) const { // HWC
  feature.clear();
  feature.resize(CHINESECHESSBOARD_SIZE * (SIZE_HISTORYEACHSIDE + 1));
  //vector<bool> feature(CHINESECHESSBOARD_SIZE * (SIZE_HISTORYEACHSIDE + 1), 0);
  // because push white into history first,
  // if next player is white,
  // we should get planes swap of each two planes
  int reverse_plane = int(Self() == RED);
  for (ChineseChessSize i = 0; i < SIZE_HISTORYEACHSIDE && i < feature_history_list_.size(); ++i) {
    const string &feature_str = *(feature_history_list_.rbegin() + (i ^ reverse_plane));
    for (int j = 0, k = i; j < CHINESECHESSBOARD_SIZE; ++j, k += (SIZE_HISTORYEACHSIDE + 1)) {
      feature[k] = feature_str[j] - '0';
    }
  }
  if (Self() == RED) {
    for (int j = 0, k = SIZE_HISTORYEACHSIDE; j < CHINESECHESSBOARD_SIZE; ++j, k += (SIZE_HISTORYEACHSIDE + 1)) {
      feature[k] = 1;
    }
  }
  return feature;
}

int ChineseChessEnv::GetActionNum() {//include RESIGN
	return 162000 + 1;
}
 
void ChineseChessEnv::GetInputDim(vector<int>& input_dim) {
    input_dim.clear();
    input_dim.push_back(SIZE_HISTORYEACHSIDE);
    input_dim.push_back(BORDER_SIZE_HEIGHT);
    input_dim.push_back(BORDER_SIZE_LENGTH)
}

void ChineseChessEnv::GetLegalAction(vector<int>& action) {
    action.clear();
    for (unsigned int i = 0; i < action_list_.size(); ++i){
        action.push_back(action_list_[i]);
    }
}

std::string ChineseChessEnv::action2str(int action){
    ChineseChessCoordId from_id, to_id;
    ChineseChessStoneColor piece;
    ChineseChessFunction::ActionToId(action, piece, from_id, to_id);
    char buffer[12];
    buffer[0] = 'f';
    buffer[1] = 'r';
    buffer[2] = 'o';
    buffer[3] = 'm';
    buffer[4] = ':';
    buffer[7] = 't';
    buffer[8] = 'o';
    buffer[9] = ':';
    ChineseChessCoordId from_x, from_y, to_x, to_y;
    ChineseChessFunction::IdToCoord(from_id, from_x, from_y);
    ChineseChessFunction::IdToCoord(to_id, to_x, to_y);
    if (!InBoard(from_x, from_y)) {
        buffer[5] = buffer[6] = 'z';
    } else if(InBoard(from_x, from_y)){
        buffer[5] = from_x + 'a';
        buffer[6] = from_y + 'a';
    }
    if (!InBoard(to_x, to_y)) {
        buffer[10] = buffer[11] = 'z';
    } else if(InBoard(to_x, to_y)){
        buffer[10] = to_x + 'a';
        buffer[11] = to_y + 'a';
    }
    return string(buffer, 12);
}

/*void ChineseChessEnv::TransformCoord(ChineseChessCoordId &x, ChineseChessCoordId &y, int mode, bool reverse = false)
{
    if (reverse) {
        if (mode & 4) std::swap(x, y);
        if (mode & 2) y = ChineseChessComm::BORDER_SIZE - y - 1;
        if (mode & 1) x = ChineseChessComm::BORDER_SIZE - x - 1;
    } else {
        if (mode & 1) x = ChineseChessComm::BORDER_SIZE - x - 1;
        if (mode & 2) y = ChineseChessComm::BORDER_SIZE - y - 1;
        if (mode & 4) std::swap(x, y);
    }
}*/
 
// void ChineseChessEnv::TransformFeatures(BaseFeature& feature, int transform_mode) {
//     BaseFeature ret(feature.size());
//     int depth = features.size() / ChineseChessComm::CHINESECHESSBOARD_SIZE;
//     for (int i = 0; i < ChineseChessComm::CHINESECHESSBOARD_SIZE; ++i) {
//         ChineseChessCoordId x, y;
//         ChineseChessFunction::IdToCoord(i, x, y);
//         TransformCoord(x, y, mode);
//         int j = ChineseChessFunction::CoordToId(x, y);
//         for (int k = 0; k < depth; ++k) {
//             ret[i * depth + k] = features[j * depth + k];
//         }
//     }
//     feature = std::move(ret);
// }

// void TransformPolicy(int transform_mode) {
// }


