#pragma once

#include <inttypes.h>
#include <string>
#include <vector>

//ChineseChess Board Id:
//  0  1  2  3  4  5  6  7  8 
//  9  10 11 12 13 14 15 15 17
// 18  19 20 21 22 23 24 25 26 
// 27  28 29 30 31 32 33 34 35
// 36  37 38 39 40 41 42 43 44
//   ....           ....
// 45  46 47 48 49 50 51 52 53
// 54  55 56 57 58 59 60 61 62
// 63  64 65 66 67 68 69 70 71
// 72  73 74 75 76 77 78 79 80
// 81  82 83 84 85 86 87 88 89
//End

// Return code of functions should be "int"
typedef uint8_t ChineseChessStoneColor;       // Stone color
typedef int16_t ChineseChessCoordId;          // Stone IDs or coordinates
typedef int32_t ChineseChessSize;             // Counts of visit times, used blocks, .. or other count //For our action space, int16 may be not enough
//typedef int16_t ChineseChessSize;             // Counts of visit times, used blocks, .. or other count

namespace ChineseChessComm {

const ChineseChessCoordId BORDER_SIZE_LENGTH = 9; // sxk_modify //y
const ChineseChessCoordId BORDER_SIZE_HEIGHT = 10;              //x
const ChineseChessCoordId CHINESECHESSBOARD_SIZE = BORDER_SIZE_LENGTH * BORDER_SIZE_HEIGHT;
const ChineseChessCoordId COORD_UNSET = -2;
//const ChineseChessCoordId COORD_PASS = -1;
const ChineseChessCoordId COORD_RESIGN = -3;

const ChineseChessStoneColor EMPTY = 0;
const ChineseChessStoneColor RED = 1;      //First player
const ChineseChessStoneColor BLACK = 2;    //Second player
const ChineseChessStoneColor WALL = 3;
const ChineseChessStoneColor RED_PAWN = 4;
const ChineseChessStoneColor RED_CANNON = 5;
const ChineseChessStoneColor RED_HORSE = 6;
const ChineseChessStoneColor RED_CHARIOT = 7;
const ChineseChessStoneColor RED_ELEPHANT = 8;
const ChineseChessStoneColor RED_ADVISER = 9;
const ChineseChessStoneColor RED_KING = 10;
const ChineseChessStoneColor BLACK_PAWN = 11;
const ChineseChessStoneColor BLACK_CANNON = 12;
const ChineseChessStoneColor BLACK_HORSE = 13;
const ChineseChessStoneColor BLACK_CHARIOT = 14;
const ChineseChessStoneColor BLACK_ELEPHANT = 15;
const ChineseChessStoneColor BLACK_ADVISER = 16;
const ChineseChessStoneColor BLACK_KING = 17;
const ChineseChessStoneColor COLOR_UNKNOWN = -1;
const char *const COLOR_STRING[] = { "Empty", "Red", "Black", "Wall", "Red Pawn", "Red Cannon", "Red Horse", "Red Chariot", "Red Elephant", "Red Adviser", "Red King", "Black Pawn", "Black Cannon", "Black Horse", "Black Chariot", "Black Elephant", "Black Adviser", "Black King" };

/*
const ChineseChessCoordId N = -9;
const ChineseChessCoordId S = 9;
const ChineseChessCoordId E = 1;
const ChineseChessCoordId W = -1;
const ChineseChessCoordId NW = -10;
const ChineseChessCoordId SW = 8;
const ChineseChessCoordId NE = -8;
const ChineseChessCoordId SE = 10;
const ChineseChessCoordId NNW = -19;
const ChineseChessCoordId NNE = -17;
const ChineseChessCoordId NWW = -11;
const ChineseChessCoordId NEE = -7;
const ChineseChessCoordId SSW = 17;
const ChineseChessCoordId SSE = 19;
const ChineseChessCoordId SWW = 7;
const ChineseChessCoordId SEE = 11;
*/

} // namespace ChineseChessComm

namespace ChineseChessFeature {

const int SIZE_HISTORYEACHSIDE = 16;
const int SIZE_PLAYERCOLOR = 1;

const int STARTPOS_HISTORYEACHSIDE = 0;
const int STARTPOS_PLAYERCOLOR = STARTPOS_HISTORYEACHSIDE + SIZE_HISTORYEACHSIDE;

const int FEATURE_COUNT = STARTPOS_PLAYERCOLOR + SIZE_PLAYERCOLOR;

} // namespace ChineseChessFeature


namespace ChineseChessFunction {

extern bool InBoard(const ChineseChessCoordId id);

extern bool InBoard(const ChineseChessCoordId x, const ChineseChessCoordId y);

extern bool IsUnset(const ChineseChessCoordId id);

extern bool IsUnset(const ChineseChessCoordId x, const ChineseChessCoordId y);

extern bool IsResign(const ChineseChessCoordId id);

extern bool IsResign(const ChineseChessCoordId x, const ChineseChessCoordId y);


extern void IdToCoord(const ChineseChessCoordId id, ChineseChessCoordId &x, ChineseChessCoordId &y);

extern ChineseChessCoordId CoordToId(const ChineseChessCoordId x, const ChineseChessCoordId y);

extern void StrToCoord(const std::string &str, ChineseChessCoordId &x, ChineseChessCoordId &y);

extern std::string CoordToStr(const ChineseChessCoordId x, const ChineseChessCoordId y);

extern std::string IdToStr(const ChineseChessCoordId id);

extern ChineseChessCoordId StrToId(const std::string &str);

extern void ActionToId(const int &action, const ChineseChessStone &stone, const ChineseChessCoordId &from_id, const ChineseChessCoordId &to_id);

extern void IdToAction(const ChineseChessStone &stone, const ChineseChessCoordId &from_id, const ChineseChessCoordId &to_id, const int &action);

extern void CreateGlobalVariables();

extern void CreateHashWeights();

extern void CreateQuickLog2Table();

extern void CreateZobristHash();

} // namespace ChineseChessFunction


//typedef std::pair<ChineseChessCoordId, ChineseChessCoordId> ChineseChessPosition;
typedef std::pair<uint64_t, uint64_t> ChineseChessHashValuePair;

extern ChineseChessHashValuePair g_hash_weight[ChineseChessComm::BORDER_SIZE_HEIGHT][ChineseChessComm::BORDER_SIZE_LENGTH];
const ChineseChessHashValuePair g_hash_unit(3, 7);
extern uint64_t g_zobrist_board_hash_weight[4][ChineseChessComm::CHINESECHESSBOARD_SIZE];
extern uint64_t g_zobrist_player_hash_weight[4];


extern ChineseChessCoordId g_log2_table[67];

#define FOR_EACHCOORD(id) for (ChineseChessCoordId id = 0; id < ChineseChessComm::CHINESECHESSBOARD_SIZE; ++id)
