#include "chess_comm.h"
#include "base_env.h"

#include <cstdlib>
#include <cstring>
#include <stack>
#include <string>
#include <unordered_set>
#include <vector>

#if defined(_WIN32) || defined(_WIN64)
#  include <intrin.h>
#  define __builtin_popcount __popcnt
#  define __builtin_popcountll __popcnt64
#endif

typedef vector<bool> BaseFeature;

 
struct ChessStone {
    ChessCoordId self_id;      // Id of this stone
    ChessCoordId next_id;      // Use like link-list
    ChessCoordId parent_id;    // Use like union-find-set (rooted by tail)

    // inline void SetSelfId(ChessCoordId id) { self_id = id; }

    inline void Reset(ChessCoordId id = ChessComm::COORD_UNSET) {
        next_id = parent_id = self_id;
    }
} ;


class ChessEnv: public BaseEnv {
public:
	ChessEnv();
    // ChessEnv(const ChessEnv &ge);
    ~ChessEnv();

    int Move(int action) override;
    bool IsFinish() override { return ((state_ != 0 ? true : false) || is_resign_); }
    void GetResult(float& res) override;
    void GetFeature(BaseFeature& feature) override;
    int GetActionNum() override;
    void GetInputDim(vector<int>& input_dim) override;
    void GetLegalAction(vector<int>& action) override;
    bool IsLegal(int action) override { return ChessFunction::IsResign(action) || IsMoveValid(action); }
    //std::string action2str(int action) override { return ChessFunction::IdToStr(const ChessCoordId action); }
    std::string action2str(int action) override;
    int CurrentPlayer() override { return current_player_; }

protected:
    // void Init();

    // void CopyFrom(const ChessEnv &src);
    //int ChessResult(ChessCoordId x, ChessCoordId y) const;
    int CalcResult() const;
    ChessStoneColor GetWinner() const;
    inline void HandOff() { current_player_ = Opponent(); }
    inline ChessStoneColor Opponent(const ChessStoneColor color = ChessComm::COLOR_UNKNOWN) const {
        return ChessComm::WHITE + ChessComm::BLACK
            - (ChessComm::COLOR_UNKNOWN != color ? color : current_player_);
    }
    inline ChessStoneColor Self() const { return current_player_; }
    inline ChessCoordId GetLastMove() const { return last_action_; }
    // inline ChessStoneColor CurrentPlayer() const { return current_player_; }
    //void ChessEnv::TransformCoord(ChessCoordId &x, ChessCoordId &y, int mode, bool reverse = false)

    void GetSensibleMove();
    bool IsSquareThreatened(ChessCoordId& id) const;
    bool IsKingInCheck() const;
    void Find_Legal_Moves() const;
    bool IsMoveValid(int& action) const;

protected:
    // board utils
    std::vector<std::int> action_list_;
    ChessStone stones_[ChessComm::CHESSBOARD_SIZE];
    ChessStoneColor board_state_[ChessComm::CHESSBOARD_SIZE];
    ChessStoneColor current_player_;
    int last_action_;
    bool is_resign_;
    int state_;
    int material_;

    // hash board state
    std::unordered_set<uint64_t> board_hash_states_;
    uint64_t zobrist_hash_value_;

    // features
    ChessSize move_count_[1073741824];

    std::vector<std::string> feature_history_list_;
};
