/*
	Base class for environments of RL.
    	Following features:
        Discrete and fix-size action space.
      Used as:
        Experiment environment;
        Environment in Agents' mind
*/
//EnCode for move(action)::
/*
stone       17
captured    10
promoted    8
from_id     64
to_id       64
Attention: all this coding part should be >= 0 for a normal action
*/
//action = stone * 64^4 + captured * 64^3 +  promoted * 64^2 + from_id * 64^1 + to_id * 64^0  //For many games, we use to_id as its action. To keep the same, to_id is the last bit.
#include <cstdlib>
#include <string>
  
class Chess: public BaseEnv {
public:
      Chess();
      ~Chess();
      virtual int Move(int action) = 0;
      virtual bool IsFinish() = 0;
      virtual void GetResult(float& res) = 0;
      virtual void GetFeature(BaseFeature& feature) = 0;
      virtual void GetActionNum() = 0;
      virtual void GetInputDim(vector<int>& input_dim) = 0;
      virtual void GetLegalAction(vector<int>& action) = 0;
      virtual bool IsLegal(int action) = 0;
      virtual std::string action2str(int action) = 0;
      //virtual void TransformFeatures(BaseFeature& feature, int transform_mode) = 0;
      //virtual void TransformPolicy(int transform_mode) = 0; // this is reverse mode of TransformFeature
protected:
      virtual void Init() = 0;
};
         