from chroma_db import *
import json

class ConceptNode(object):
    def __init__(self, node_id, node_type,
                 description, summary, code,
                 poignancy, last_accessed, created):
        self.node_id = node_id
        self.node_type = node_type

        self.description = description
        self.summary = summary
        self.code = code

        self.poignancy = poignancy
        self.last_accessed = last_accessed
        self.created = created

    def to_json(self):
        return {
            'node_id': self.node_id,
            'node_type': self.node_type,
            'description': self.description,
            'summary': self.summary,
            'code': self.code,
            'poignancy': self.poignancy,
            'last_accessed': self.last_accessed,
            'created': self.created
        }

class MemoryStream(object):
    def __init__(self, db_file_name, collection_name):
        self.collection = get_collection(db_file_name, collection_name)
        self.now_id = 1

    def add_record_in_mem(self, r_type, description, code,
                          summary, now_time, poignancy):
        node_id = self.now_id
        self.now_id += 1

        node = ConceptNode(node_id, r_type, description,
                           summary, code, poignancy,
                           last_accessed=now_time, created=now_time)
        add_record(self.collection, node.to_json())

    def add_bug_report_in_mem(self, description, summary,
                              now_time):
        node_id = self.now_id
        self.now_id += 1

        node = ConceptNode(node_id, 'event', description,
                           summary, 'NULL', 10, 
                           last_accessed=now_time, created=now_time)
        add_record(self.collection, node.to_json())
    
        

