import aiohttp
from chroma_memory_stream import MemoryStream
import chroma_retrieve
import run_gpt

api_file = 'key.txt'

def get_key(api_key_f):
    with open(api_key_f, 'r') as f:
        key = f.read().strip()
    return key

def run_gpt_event_poignancy_prompt(api_key_f, record):
    key = get_key(api_key_f)
    for _ in range(10):
        try:
            return int(run_gpt.gpt_request(key, record, 'prompt/poignancy_event.txt'))
        except:
            pass

def run_gpt_chat_poignancy_prompt(api_key_f, chat_history):
    key = get_key(api_key_f)
    for _ in range(10):
        try:
            return int(run_gpt.gpt_request(key, chat_history, 'prompt/poignancy_chat.txt'))
        except:
            pass

def run_gpt_skill_poignancy_prompt(api_key_f, skill_desc):
    key = get_key(api_key_f)
    for _ in range(10):
        try:
            return int(run_gpt.gpt_request(key, skill_desc, 'prompt/poignancy_skill.txt'))
        except:
            pass

def run_gpt_summary_event_prompt(api_key_f, record):
   key = get_key(api_key_f)
   return run_gpt.gpt_request(key, record, 'prompt/summary_event.txt')

def run_gpt_summary_chat_prompt(api_key_f, chat_history):
    key = get_key(api_key_f)
    return run_gpt.gpt_request(key, chat_history, 'prompt/summary_chat.txt')


def parse_observations(observation:dict):
    description = ''
    description += f"Name: {observation['name']}\n"
    description += f"Entities: {observation['entities']}\n"
    description += f"Health: {observation['health']} Food: {observation['food']} " +\
                     f"Saturation: {observation['saturation']} Oxygen: {observation['oxygen']}\n"
    description += f"Position: {observation['position']} Velocity: {observation['velocity']} " + \
                    f"Yaw: {observation['yaw']} Pitch: {observation['pitch']} IsonGroud: {observation['groud']}\n"
    description += f"TimeSinceOnGround: {observation['timeSinceOnGroud']}\n"
    description += f"IsInwater: {observation['isInwater']} IsInLava: {observation['isInLava']}" + \
                   f"IsInweb: {observation['isInWeb']} IsCollidedHorizontally: {observation['isCollidedHorizontally']} "+ \
                   f"IsCollidedVertically: {observation['isCollidedVertically']}\n"
    description += f"TimeofDay: {observation['timeOfDay']}\n"
    description += f"InventoryUsed: {observation['inventoryUsed']}\n"
    return description

class MemoryAPIs(object):
    def __init__(self, db_file_name, collection_name):
        self.memory_stream = MemoryStream(db_file_name=db_file_name, collection_name=collection_name)

    async def receive_web_info(self, ip, port):
        pass

    async def send_result(self, ip, port, res):
        pass

    async def get_now_time(self, ip, port):
        pass

    def add_chat_to_mem(self, chat_history, summary, now_time):
        """
        Add chat history to the memory.
        The *chat_history* should be formulated as below:

        Ann: How's everything going?
        Bill: Fine.
        ...


        """
        r_type = 'chat'
        description = chat_history
        code = 'NULL'
        poignancy = run_gpt_chat_poignancy_prompt(api_key_f=api_file, chat_history=description)
        poignancy = poignancy if poignancy is not None else 4
        self.memory_stream.add_record_in_mem(r_type, description, code,
                                             summary, now_time, poignancy)

    def add_event_to_mem(self, description, summary, now_time):
        """
        Add observation to the memory.
        The *observation* is a python dict
        """
        r_type = 'event'
        code = 'NULL'
        poignancy = run_gpt_event_poignancy_prompt(api_key_f=api_file, record=description)
        poignancy = poignancy if poignancy is not None else 4
        self.memory_stream.add_record_in_mem(r_type, description, code,
                                             summary, now_time, poignancy)
        pass

    def add_skill_to_mem(self, skill_info, now_time):
        """
        Add skill to the memory.
        The *sill_info* is a python dict, which has the field 'code' and 'description'  
        """
        r_type = 'skill'
        description = skill_info['description']
        code = skill_info['code']
        summary = 'NULL'
        poignancy = run_gpt_skill_poignancy_prompt(api_key_f=api_file, skill_desc=description)
        poignancy = poignancy if poignancy is not None else 4
        self.memory_stream.add_record_in_mem(r_type, description, code,
                                             summary, now_time, poignancy)

    def add_bug_info_to_mem(self, bug_info, summary, now_time):
        """
        Add skill to the memory.
        The *sill_info* is a python dict, which has the field 'code' and 'description'  
        """
        self.memory_stream.add_bug_report_in_mem(bug_info, summary, now_time)

    def delete_record_in_mem(self):
        pass

    def retrieve_mem(self, msg):
        return chroma_retrieve.retrieve(self.memory_stream.collection, [msg], topK=10)

    def circle(self, msg, r_type):
        """
        The main memory circle.
        R_type can be: chat/event/skill/bug
        """
        if r_type == 'chat':
            desc = msg
            summary = run_gpt_summary_chat_prompt(api_key_f=api_file, chat_history=desc)
            retrieved_msgs = self.retrieve_mem(summary)
            now_time = self.get_now_time()
            self.add_chat_to_mem(desc, summary, now_time)
        elif r_type == 'event':
            desc = parse_observations(msg)
            summary = run_gpt_summary_event_prompt(api_key_f=api_file, record=desc)
            retrieved_msgs = self.retrieve_mem(summary)
            now_time = self.get_now_time()
            self.add_event_to_mem(desc, summary, now_time)
        elif r_type == 'skill':
            desc = msg['description']
            retrieved_msgs = self.retrieve_mem(desc)
            now_time = self.get_now_time()
            self.add_skill_to_mem(msg, now_time)
        elif r_type == 'bug':
            desc = msg
            summary = run_gpt_summary_event_prompt(api_key_f=api_file, record=desc)
            now_time = self.get_now_time(),
            retrieved_msgs = None
            self.add_bug_info_to_mem(msg, summary, now_time)
        else:
            raise NotImplementedError("Not supported node type.")
        
        return retrieved_msgs